/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.api.common;

import exterminatorjeff.undergroundbiomes.api.API;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class UBLogger {
    private static final Logger LOGGER = LogManager.getLogger((String)"undergroundbiomes");
    private final String name;
    private final Level maxLevel;

    public UBLogger(Level maxLevel) {
        this((String)null, maxLevel);
    }

    public UBLogger(Class<?> clazz, Level maxLevel) {
        this(clazz.getSimpleName(), maxLevel);
    }

    public UBLogger(String name, Level maxLevel) {
        this.name = name;
        this.maxLevel = Level.DEBUG;
    }

    private void log(Level level, String message) {
        if (level.isMoreSpecificThan(this.maxLevel) || level.compareTo(this.maxLevel) == 0) {
            String prefix;
            String string = prefix = "undergroundbiomes " + this.name == null ? "" : "[" + this.name + "] ";
            if ((level == Level.ERROR || level == Level.FATAL) && API.SETTINGS.crashOnProblems()) {
                throw new RuntimeException(prefix + message);
            }
            LOGGER.log(level, prefix + message);
        }
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message);
    }

    public void error(String message) {
        this.log(Level.ERROR, message);
    }

    public void warn(String message) {
        this.log(Level.WARN, message);
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    public void trace(String message) {
        this.log(Level.TRACE, message);
    }
}

