/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.elements.AbstractElementPanel;

public class ElementHorizontal
extends AbstractElementPanel {
    public static final int SPACING = 5;

    public ElementHorizontal(Integer borderColor, int spacing, ElementAlignment alignment) {
        super(borderColor, spacing, alignment);
    }

    public ElementHorizontal(ByteBuf buf) {
        super(buf);
    }

    @Override
    public void render(int x, int y) {
        super.render(x, y);
        if (this.borderColor != null) {
            x += 3;
            y += 3;
        }
        int totHeight = this.getHeight();
        for (IElement element : this.children) {
            int h = element.getHeight();
            int cy = y;
            switch (this.alignment) {
                case ALIGN_TOPLEFT: {
                    break;
                }
                case ALIGN_CENTER: {
                    cy = y + (totHeight - h) / 2;
                    break;
                }
                case ALIGN_BOTTOMRIGHT: {
                    cy = y + totHeight - h;
                }
            }
            element.render(x, cy);
            x += element.getWidth() + this.spacing;
        }
    }

    private int getBorderSpacing() {
        return this.borderColor == null ? 0 : 6;
    }

    @Override
    public int getWidth() {
        int w = 0;
        for (IElement element : this.children) {
            w += element.getWidth();
        }
        return w + this.spacing * (this.children.size() - 1) + this.getBorderSpacing();
    }

    @Override
    public int getHeight() {
        int h = 0;
        for (IElement element : this.children) {
            int hh = element.getHeight();
            if (hh <= h) continue;
            h = hh;
        }
        return h + this.getBorderSpacing();
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_HORIZONTAL;
    }
}

