/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.compatibility.hwyla;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import omtteam.omlib.compatibility.hwyla.IOMLibWailaDataProvider;
import omtteam.omlib.util.GeneralUtil;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public class WailaTurretHandler
implements IOMLibWailaDataProvider {
    public void callbackRegister(IWailaRegistrar register) {
        WailaTurretHandler instance = new WailaTurretHandler();
        register.registerNBTProvider((IWailaDataProvider)instance, TurretHead.class);
        register.registerBodyProvider((IWailaDataProvider)instance, TurretHead.class);
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TurretHead) {
            TurretHead turret = (TurretHead)te;
            boolean active = accessor.getNBTData().func_74767_n("active");
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:active") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)active));
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:owner") + ": \u00a7F" + accessor.getNBTData().func_74779_i("ownerName"));
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:ammo") + ": \u00a7F" + TurretHeadUtil.getAmmoLevel(turret, turret.getBase()));
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:damage_amp") + ": \u00a7F" + accessor.getNBTData().func_74779_i("ampLevel") + "%");
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:accuracy") + ": \u00a7F" + accessor.getNBTData().func_74779_i("accuracy") + "%");
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:rof") + ": \u00a7F" + accessor.getNBTData().func_74779_i("rof") + "s/sec");
        }
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof TurretHead) {
            TurretHead turret = (TurretHead)te;
            tag.func_74757_a("active", turret.getBase().isActive());
            tag.func_74778_a("ownerName", turret.getOwner().getName());
            tag.func_74768_a("ammoLevel", TurretHeadUtil.getAmmoLevel(turret, turret.getBase()));
            tag.func_74778_a("ampLevel", String.format("%.2f", turret.getTurretDamageAmpBonus() * 100.0 * (double)TurretHeadUtil.getAmpLevel(turret.getBase())));
            tag.func_74778_a("accuracy", String.format("%.2f", Math.min(100.0, (100.0 - turret.getBaseTurretAccuracy() * 10.0) * (1.0 + (double)TurretHeadUtil.getAccuraccyUpgrades(turret.getBase(), turret)))));
            tag.func_74778_a("rof", String.format("%.2f", Float.valueOf(20.0f / ((float)turret.getTurretBaseFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(turret.getBase(), turret))))));
        }
        return tag;
    }
}

