/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.custom.component;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.IItemStacksRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;

public class IngredientsRecipeComponent
implements IRecipeInput,
IRecipeOutput,
IRecipeProperties,
IItemStacksRecipeComponent {
    private final List<IngredientRecipeComponent> ingredients;
    private float chance;

    public IngredientsRecipeComponent(NonNullList<Ingredient> ingredients) {
        this.ingredients = Lists.transform(ingredients, (Function)new Function<Ingredient, IngredientRecipeComponent>(){

            @Nullable
            public IngredientRecipeComponent apply(Ingredient input) {
                return new IngredientRecipeComponent(input);
            }
        });
    }

    public IngredientsRecipeComponent(List<IngredientRecipeComponent> ingredients) {
        this.ingredients = ingredients;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IngredientsRecipeComponent)) {
            return false;
        }
        IngredientsRecipeComponent that = (IngredientsRecipeComponent)object;
        return this.equals(this.ingredients, that.ingredients);
    }

    protected boolean equals(List<IngredientRecipeComponent> a, List<IngredientRecipeComponent> b) {
        if (a.size() == b.size()) {
            for (int i = 0; i < a.size(); ++i) {
                if (a.get(i).equals(b.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 876;
        for (IngredientRecipeComponent itemStack : this.ingredients) {
            hash |= itemStack.hashCode();
        }
        return hash;
    }

    @Override
    public List<ItemStack> getIngredients() {
        return this.ingredients.stream().map(IngredientRecipeComponent::getItemStacks).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<IngredientRecipeComponent> getSubIngredientComponents() {
        return this.ingredients;
    }

    public List<IngredientRecipeComponent> getIngredientComponents() {
        return this.ingredients;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public String toString() {
        return "IngredientsRecipeComponent(ingredients=" + this.getIngredients() + ", chance=" + this.getChance() + ")";
    }
}

