/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.custom;

import java.util.ArrayList;
import java.util.List;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.recipe.custom.Recipe;
import org.cyclops.cyclopscore.recipe.custom.RecipePropertyMatcher;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeMatcher;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.api.ISuperRecipeRegistry;

public class RecipeRegistry<M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
implements IRecipeRegistry<M, I, O, P> {
    private final M machine;
    private final ModBase mod;

    public RecipeRegistry(M machine, ModBase mod) {
        this.machine = machine;
        this.mod = mod;
    }

    @Override
    public IRecipe<I, O, P> registerRecipe(IRecipe<I, O, P> recipe) {
        this.getMod().getRegistryManager().getRegistry(ISuperRecipeRegistry.class).getRecipes((IMachine)this.machine).add(recipe);
        return recipe;
    }

    @Override
    public IRecipe<I, O, P> registerRecipe(String namedId, I input, O output, P properties) {
        return this.registerRecipe(new Recipe<I, O, P>(namedId, input, output, properties));
    }

    @Override
    public IRecipe<I, O, P> registerRecipe(I input, O output, P properties) {
        return this.registerRecipe(new Recipe<I, O, P>(input, output, properties));
    }

    @Override
    public IRecipe<I, O, P> unregisterRecipe(IRecipe<I, O, P> recipe) {
        if (this.getMod().getRegistryManager().getRegistry(ISuperRecipeRegistry.class).getRecipes((IMachine)this.machine).remove(recipe)) {
            return recipe;
        }
        return null;
    }

    @Override
    public IRecipe<I, O, P> unregisterRecipe(String namedId, I input, O output, P properties) {
        return this.unregisterRecipe(new Recipe<I, O, P>(namedId, input, output, properties));
    }

    @Override
    public IRecipe<I, O, P> unregisterRecipe(I input, O output, P properties) {
        return this.unregisterRecipe(new Recipe<I, O, P>(input, output, properties));
    }

    @Override
    public IRecipe<I, O, P> findRecipeByNamedId(String namedId) {
        return this.findRecipe(new RecipePropertyMatcher<M, IRecipe<I, O, P>, String>(namedId){

            @Override
            public String getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getNamedId();
            }
        });
    }

    @Override
    public IRecipe<I, O, P> findRecipeByInput(I input) {
        return this.findRecipe(new RecipePropertyMatcher<M, IRecipe<I, O, P>, I>((IRecipeInput)input){

            @Override
            public I getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getInput();
            }
        });
    }

    @Override
    public List<IRecipe<I, O, P>> findRecipesByInput(I input) {
        return this.findRecipes(new RecipePropertyMatcher<M, IRecipe<I, O, P>, I>((IRecipeInput)input){

            @Override
            public I getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getInput();
            }
        });
    }

    @Override
    public IRecipe<I, O, P> findRecipeByOutput(O output) {
        return this.findRecipe(new RecipePropertyMatcher<M, IRecipe<I, O, P>, O>((IRecipeOutput)output){

            @Override
            public O getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getOutput();
            }
        });
    }

    @Override
    public List<IRecipe<I, O, P>> findRecipesByOutput(O output) {
        return this.findRecipes(new RecipePropertyMatcher<M, IRecipe<I, O, P>, O>((IRecipeOutput)output){

            @Override
            public O getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getOutput();
            }
        });
    }

    @Override
    public IRecipe<I, O, P> findRecipe(IRecipeMatcher<M, IRecipe<I, O, P>> recipeMatcher) {
        for (IRecipe r : this.getMod().getRegistryManager().getRegistry(ISuperRecipeRegistry.class).getRecipes((IMachine)this.machine)) {
            IRecipe recipe = r;
            if (!recipeMatcher.matches(this.machine, recipe)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public List<IRecipe<I, O, P>> findRecipes(IRecipeMatcher<M, IRecipe<I, O, P>> recipeMatcher) {
        ArrayList<IRecipe<I, O, P>> results = new ArrayList<IRecipe<I, O, P>>();
        for (IRecipe r : this.getMod().getRegistryManager().getRegistry(ISuperRecipeRegistry.class).getRecipes((IMachine)this.machine)) {
            IRecipe recipe = r;
            if (!recipeMatcher.matches(this.machine, recipe)) continue;
            results.add(recipe);
        }
        return results;
    }

    @Override
    public List<IRecipe<I, O, P>> allRecipes() {
        return this.getMod().getRegistryManager().getRegistry(ISuperRecipeRegistry.class).getRecipes((IMachine)this.machine);
    }

    @Override
    public ModBase getMod() {
        return this.mod;
    }
}

