/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Supplier;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;

public abstract class RegistryExportableRecipeAbstract<I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
implements IRegistryExportable {
    private final Supplier<IRecipeRegistry<?, I, O, P>> recipeRegistry;
    private final String name;

    protected RegistryExportableRecipeAbstract(Supplier<IRecipeRegistry<?, I, O, P>> recipeRegistry, String name) {
        this.recipeRegistry = recipeRegistry;
        this.name = name;
    }

    public IRecipeRegistry<?, I, O, P> getRecipeRegistry() {
        return this.recipeRegistry.get();
    }

    @Override
    public JsonObject export() {
        JsonObject element = new JsonObject();
        JsonArray elements = new JsonArray();
        element.add("recipes", (JsonElement)elements);
        ListMultimap taggedRecipeReverse = Multimaps.newListMultimap((Map)Maps.newHashMap(), Lists::newArrayList);
        for (Map.Entry entry : this.getRecipeRegistry().getMod().getRecipeHandler().getTaggedRecipes().entries()) {
            taggedRecipeReverse.put(entry.getValue(), entry.getKey());
        }
        for (IRecipe iRecipe : this.getRecipeRegistry().allRecipes()) {
            JsonObject serializedRecipe = this.serializeRecipe(iRecipe);
            JsonArray tagsArray = new JsonArray();
            for (String tag : taggedRecipeReverse.get((Object)iRecipe)) {
                tagsArray.add(tag);
            }
            serializedRecipe.add("tags", (JsonElement)tagsArray);
            elements.add((JsonElement)serializedRecipe);
        }
        return element;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract JsonObject serializeRecipe(IRecipe<I, O, P> var1);
}

