/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class SimpleInventory
implements INBTInventory {
    protected final ItemStack[] _contents;
    private final String _name;
    private final int _stackLimit;
    private final List<IDirtyMarkListener> dirtyMarkListeners = Lists.newLinkedList();

    public SimpleInventory() {
        this(0, "", 0);
    }

    public SimpleInventory(int size, String name, int stackLimit) {
        this._contents = new ItemStack[size];
        for (int i = 0; i < this._contents.length; ++i) {
            this._contents[i] = ItemStack.field_190927_a;
        }
        this._name = name;
        this._stackLimit = stackLimit;
    }

    public synchronized void addDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.add(dirtyMarkListener);
    }

    public synchronized void removeDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.remove(dirtyMarkListener);
    }

    public int func_70302_i_() {
        return this._contents.length;
    }

    public ItemStack func_70301_a(int slotId) {
        return this._contents[slotId];
    }

    public ItemStack func_70298_a(int slotId, int count) {
        ItemStack stack = this.func_70301_a(slotId);
        if (slotId < this.func_70302_i_() && !stack.func_190926_b()) {
            if (stack.func_190916_E() > count) {
                ItemStack slotContents = stack.func_77946_l();
                ItemStack result = slotContents.func_77979_a(count);
                this.func_70299_a(slotId, slotContents);
                return result;
            }
            this.func_70299_a(slotId, ItemStack.field_190927_a);
            this.onInventoryChanged();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        if (slotId >= this.func_70302_i_()) {
            return;
        }
        this._contents[slotId] = Objects.requireNonNull(itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.onInventoryChanged();
    }

    public int func_70297_j_() {
        return this._stackLimit;
    }

    protected void onInventoryChanged() {
        this.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer playerIn) {
    }

    public void func_174886_c(EntityPlayer playerIn) {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.readFromNBT(data, "items");
    }

    public void readFromNBT(NBTTagCompound data, String tag) {
        int j;
        NBTTagList nbttaglist = data.func_150295_c(tag, MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (j = 0; j < this.func_70302_i_(); ++j) {
            this._contents[j] = ItemStack.field_190927_a;
        }
        for (j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound slot = nbttaglist.func_150305_b(j);
            int index = slot.func_74764_b("index") ? slot.func_74762_e("index") : (int)slot.func_74771_c("Slot");
            if (index < 0 || index >= this.func_70302_i_()) continue;
            this._contents[index] = new ItemStack(slot);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        this.writeToNBT(data, "items");
    }

    public void writeToNBT(NBTTagCompound data, String tag) {
        NBTTagList slots = new NBTTagList();
        for (byte index = 0; index < this.func_70302_i_(); index = (byte)((byte)(index + 1))) {
            ItemStack itemStack = this.func_70301_a(index);
            if (itemStack.func_190926_b() || itemStack.func_190916_E() <= 0) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slots.func_74742_a((NBTBase)slot);
            slot.func_74774_a("Slot", index);
            itemStack.func_77955_b(slot);
        }
        data.func_74782_a(tag, (NBTBase)slots);
    }

    public ItemStack func_70304_b(int slotId) {
        ItemStack stackToTake = this.func_70301_a(slotId);
        if (stackToTake.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_70299_a(slotId, ItemStack.field_190927_a);
        return stackToTake;
    }

    public ItemStack[] getItemStacks() {
        return this._contents;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i < this.func_70302_i_() && i >= 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this._contents[i] = ItemStack.field_190927_a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70296_d() {
        LinkedList dirtyMarkListeners;
        SimpleInventory simpleInventory = this;
        synchronized (simpleInventory) {
            dirtyMarkListeners = Lists.newLinkedList(this.dirtyMarkListeners);
        }
        for (IDirtyMarkListener dirtyMarkListener : dirtyMarkListeners) {
            dirtyMarkListener.onDirty();
        }
    }

    public String func_70005_c_() {
        return this._name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return tag;
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }
}

