/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.api.capability.itemhandler.SlotlessItemHandlerWrapper;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;

public class IndexedSlotlessItemHandlerWrapper
extends SlotlessItemHandlerWrapper {
    private final IInventoryIndexReference inventory;

    public IndexedSlotlessItemHandlerWrapper(IItemHandler itemHandler, IInventoryIndexReference inventory) {
        super(itemHandler);
        this.inventory = inventory;
    }

    protected PrimitiveIterator.OfInt getNonFullSlotsWithItemStack(@Nonnull ItemStack itemStack, int matchFlags) {
        if (!IngredientComponent.ITEMSTACK.getMatcher().hasCondition((Object)matchFlags, (Object)1)) {
            return IntStream.range(0, this.itemHandler.getSlots()).filter(slot -> {
                ItemStack slotStack = this.itemHandler.getStackInSlot(slot);
                return ItemMatch.areItemStacksEqual((ItemStack)slotStack, (ItemStack)itemStack, (int)matchFlags) && slotStack.func_190916_E() < this.itemHandler.getSlotLimit(slot) && slotStack.func_190916_E() < slotStack.func_77976_d();
            }).iterator();
        }
        Map<Item, Int2ObjectMap<ItemStack>> items = this.inventory.getIndex();
        Int2ObjectMap<ItemStack> stacks = items.get(itemStack.func_77973_b());
        if (stacks != null) {
            return stacks.int2ObjectEntrySet().stream().filter(entry -> ((ItemStack)entry.getValue()).func_190916_E() < Math.min(this.inventory.getInventoryStackLimit(), ((ItemStack)entry.getValue()).func_77976_d()) && ItemMatch.areItemStacksEqual((ItemStack)((ItemStack)entry.getValue()), (ItemStack)itemStack, (int)matchFlags)).mapToInt(Int2ObjectMap.Entry::getIntKey).iterator();
        }
        return IntStream.empty().iterator();
    }

    protected PrimitiveIterator.OfInt getNonEmptySlotsWithItemStack(@Nonnull ItemStack itemStack, int matchFlags) {
        if (!IngredientComponent.ITEMSTACK.getMatcher().hasCondition((Object)matchFlags, (Object)1)) {
            return IndexedSlotlessItemHandlerWrapper.intIteratorToStream(this.getNonEmptySlots()).filter(slot -> {
                ItemStack slotStack = this.itemHandler.getStackInSlot(slot);
                return !slotStack.func_190926_b() && ItemMatch.areItemStacksEqual((ItemStack)slotStack, (ItemStack)itemStack, (int)matchFlags);
            }).iterator();
        }
        Map<Item, Int2ObjectMap<ItemStack>> items = this.inventory.getIndex();
        Int2ObjectMap<ItemStack> stacks = items.get(itemStack.func_77973_b());
        if (stacks != null) {
            return stacks.int2ObjectEntrySet().stream().filter(entry -> ItemMatch.areItemStacksEqual((ItemStack)((ItemStack)entry.getValue()), (ItemStack)itemStack, (int)matchFlags)).mapToInt(Int2ObjectMap.Entry::getIntKey).iterator();
        }
        return IntStream.empty().iterator();
    }

    protected PrimitiveIterator.OfInt getSlotsWithItemStack(@Nonnull ItemStack itemStack, int matchFlags) {
        if (!IngredientComponent.ITEMSTACK.getMatcher().hasCondition((Object)matchFlags, (Object)1)) {
            return IntStream.range(0, this.itemHandler.getSlots()).filter(slot -> ItemMatch.areItemStacksEqual((ItemStack)this.itemHandler.getStackInSlot(slot), (ItemStack)itemStack, (int)matchFlags)).iterator();
        }
        Map<Item, Int2ObjectMap<ItemStack>> items = this.inventory.getIndex();
        Int2ObjectMap<ItemStack> stacks = items.get(itemStack.func_77973_b());
        if (stacks == null) {
            return IntStream.empty().iterator();
        }
        return stacks.int2ObjectEntrySet().stream().filter(entry -> ItemMatch.areItemStacksEqual((ItemStack)((ItemStack)entry.getValue()), (ItemStack)itemStack, (int)matchFlags)).mapToInt(Int2ObjectMap.Entry::getIntKey).iterator();
    }

    protected PrimitiveIterator.OfInt getEmptySlots() {
        return this.inventory.getEmptySlots();
    }

    protected PrimitiveIterator.OfInt getNonEmptySlots() {
        return this.inventory.getNonEmptySlots();
    }

    public static IntStream intIteratorToStream(PrimitiveIterator.OfInt it) {
        return StreamSupport.intStream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    public static class WrappedIntIterator
    implements PrimitiveIterator.OfInt {
        private final IntIterator it;

        public WrappedIntIterator(IntIterator it) {
            this.it = it;
        }

        @Override
        public int nextInt() {
            return this.it.nextInt();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Integer next() {
            return (Integer)this.it.next();
        }
    }

    public static class IndexIterator
    implements IntIterator {
        private final Iterator<Int2ObjectMap.Entry<ItemStack>> slotIterator;
        private final ItemStack prototype;
        private final int matchFlags;
        private int next;

        public IndexIterator(Iterator<Int2ObjectMap.Entry<ItemStack>> slotIterator, ItemStack prototype, int matchFlags) {
            this.slotIterator = slotIterator;
            this.prototype = prototype;
            this.matchFlags = matchFlags;
            this.next = this.findNext();
        }

        protected int findNext() {
            while (this.slotIterator.hasNext()) {
                Int2ObjectMap.Entry<ItemStack> entry = this.slotIterator.next();
                int slot = entry.getIntKey();
                ItemStack itemStack = (ItemStack)entry.getValue();
                if (!ItemMatch.areItemStacksEqual((ItemStack)itemStack, (ItemStack)this.prototype, (int)this.matchFlags)) continue;
                return slot;
            }
            return -1;
        }

        public boolean hasNext() {
            return this.next > 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Slot out of bounds");
            }
            int next = this.next;
            this.next = this.findNext();
            return next;
        }

        public int skip(int n) {
            int skipped = 0;
            while (n > 0 && this.hasNext()) {
                this.nextInt();
                ++skipped;
            }
            return skipped;
        }
    }

    public static interface IInventoryIndexReference {
        public int getInventoryStackLimit();

        public Map<Item, Int2ObjectMap<ItemStack>> getIndex();

        public PrimitiveIterator.OfInt getEmptySlots();

        public PrimitiveIterator.OfInt getNonEmptySlots();
    }
}

