/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.IModVersion;

public abstract class ModBaseVersionable
extends ModBase
implements IModVersion {
    private boolean versionInfo = false;
    private String version;
    private String info;
    private String updateUrl;

    public ModBaseVersionable(String modId, String modName, String modVersion) {
        super(modId, modName);
        this.putGenericReference(REFKEY_MOD_VERSION, modVersion);
    }

    @Override
    public void setVersionInfo(String version, String info, String updateUrl) {
        this.versionInfo = true;
        this.version = version;
        this.info = info;
        this.updateUrl = updateUrl;
    }

    @Override
    public boolean isVersionInfo() {
        return this.versionInfo;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public String getUpdateUrl() {
        return this.updateUrl;
    }

    @Override
    public boolean needsUpdate() {
        String currentVersionString = (String)this.getReferenceValue(REFKEY_MOD_VERSION);
        String latestVersionString = this.getVersion();
        if (latestVersionString == null || "@VERSION@".equals(currentVersionString)) {
            return false;
        }
        DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(currentVersionString);
        DefaultArtifactVersion newVersion = new DefaultArtifactVersion(latestVersionString);
        return this.getVersion() != null && currentVersion.compareTo((Object)newVersion) < 0;
    }
}

