/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.capability.fluid;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacityConfig;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class FluidHandlerItemCapacity
extends FluidHandlerItemStack
implements IFluidHandlerItemCapacity {
    private final Fluid fluid;

    public FluidHandlerItemCapacity(ItemStack container, int capacity) {
        this(container, capacity, null);
    }

    public FluidHandlerItemCapacity(ItemStack container, int capacity, Fluid fluid) {
        super(container, capacity);
        this.fluid = fluid;
    }

    public boolean canFillFluidType(FluidStack resource) {
        return this.fluid == null || resource == null || this.fluid == resource.getFluid();
    }

    @Override
    public void setCapacity(int capacity) {
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound(this.getContainer());
        this.capacity = capacity;
        tag.func_74768_a("capacity", capacity);
    }

    @Override
    public int getCapacity() {
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound(this.getContainer());
        return tag.func_150297_b("capacity", MinecraftHelpers.NBTTag_Types.NBTTagInt.ordinal()) ? tag.func_74762_e("capacity") : this.capacity;
    }

    @Nullable
    public FluidStack getFluid() {
        this.capacity = this.getCapacity();
        return super.getFluid();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == FluidHandlerItemCapacityConfig.CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == FluidHandlerItemCapacityConfig.CAPABILITY ? this : super.getCapability(capability, facing));
    }

    public static class Storage
    implements Capability.IStorage<IFluidHandlerItemCapacity> {
        public NBTBase writeNBT(Capability<IFluidHandlerItemCapacity> capability, IFluidHandlerItemCapacity instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            FluidStack fluid = ((FluidHandlerItemCapacity)instance).getFluid();
            if (fluid != null) {
                fluid.writeToNBT(nbt);
            } else {
                nbt.func_74778_a("Empty", "");
            }
            nbt.func_74768_a("capacity", instance.getCapacity());
            return nbt;
        }

        public void readNBT(Capability<IFluidHandlerItemCapacity> capability, IFluidHandlerItemCapacity instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tags = (NBTTagCompound)nbt;
            if (tags.func_150297_b("capacity", MinecraftHelpers.NBTTag_Types.NBTTagInt.ordinal())) {
                instance.setCapacity(tags.func_74762_e("capacity"));
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags);
            ((FluidHandlerItemCapacity)instance).setFluid(fluid);
        }
    }
}

