/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.util;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;

public class Toolbox {
    public static String formatUnit(long unit, String singular, String plural) {
        if (unit == 1L) {
            return singular;
        }
        return plural;
    }

    public static boolean saveCrashReport(CrashReport crashReport) {
        Path crashPath = Paths.get("crash-reports", new String[0]).resolve("crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
        if (crashReport.func_147149_a(crashPath.toFile())) {
            Sledgehammer.getInstance().getLogger().info("This crash report has been saved to: {}", (Object)crashPath);
            return true;
        }
        Sledgehammer.getInstance().getLogger().error("We were unable to save this crash report to disk.");
        return false;
    }

    public static Chunk getLoadedChunkWithoutMarkingActive(World world, int chunkX, int chunkZ) {
        IChunkProvider chunkProvider = world.func_72863_F();
        if (chunkProvider instanceof ChunkProviderServer) {
            return (Chunk)((ChunkProviderServer)chunkProvider).field_73244_f.get(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
        }
        return chunkProvider.func_186026_b(chunkX, chunkZ);
    }

    public static String getRootId(Entity entity) {
        ItemStack itemStack;
        if (entity instanceof EntityItem && !(itemStack = ((EntityItem)entity).func_92059_d()).func_190926_b()) {
            return Toolbox.getResourceLocation(itemStack.func_77973_b()).map(ResourceLocation::toString).orElse("Unknown");
        }
        return Toolbox.getResourceLocation(entity).map(ResourceLocation::toString).orElse("Unknown");
    }

    public static Optional<ResourceLocation> getResourceLocation(Object object) {
        if (object instanceof Block) {
            return Optional.of(Block.field_149771_c.func_177774_c((Object)((Block)object)));
        }
        if (object instanceof Entity) {
            return Optional.ofNullable(EntityList.func_191301_a((Entity)((Entity)object)));
        }
        if (object instanceof Item) {
            return Optional.ofNullable(Item.field_150901_e.func_177774_c((Object)((Item)object)));
        }
        return Optional.empty();
    }

    public static String getClassSimpleName(Class<?> type) {
        if (type.getEnclosingClass() != null) {
            return Toolbox.getClassSimpleName(type.getEnclosingClass()) + "." + type.getSimpleName();
        }
        return type.getSimpleName();
    }

    public static <T> T cast(Object object, Class<? extends T> type) {
        return type.cast(object);
    }

    public static <T> T newInstance(Class<? extends T> type) {
        try {
            return type.newInstance();
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

