/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.util;

import com.google.common.collect.Lists;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import java.util.List;
import net.minecraft.network.INetHandler;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;

public class NetworkChannelHelper
implements Runnable {
    private static final List<ChannelOutboundInvoker> markedChannels = Lists.newArrayList();
    public static final int flushDelay = Integer.getInteger("fml.network.flushDelay", 50);

    @Override
    public void run() {
        try {
            while (true) {
                NetworkChannelHelper.flushAllChannels();
                Thread.sleep(flushDelay);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static ChannelFuture writeAndFlush(ChannelOutboundInvoker channel, Object msg, INetHandler packetListener) {
        if (packetListener == null) {
            return channel.writeAndFlush(msg);
        }
        if (packetListener instanceof INetHandlerPlayClient || packetListener instanceof INetHandlerPlayServer) {
            return NetworkChannelHelper.writeAndFlush(channel, msg);
        }
        return channel.writeAndFlush(msg);
    }

    public static ChannelFuture writeAndFlush(ChannelOutboundInvoker channel, Object msg) {
        if (NetworkChannelHelper.isInstantFlushEnabled()) {
            return channel.writeAndFlush(msg);
        }
        NetworkChannelHelper.markForFlush(channel);
        return channel.write(msg);
    }

    public static ChannelFuture writeAndFlush(ChannelOutboundInvoker channel, Object msg, ChannelPromise promise) {
        if (NetworkChannelHelper.isInstantFlushEnabled()) {
            return channel.writeAndFlush(msg, promise);
        }
        NetworkChannelHelper.markForFlush(channel);
        return channel.write(msg, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markForFlush(ChannelOutboundInvoker channel) {
        List<ChannelOutboundInvoker> list = markedChannels;
        synchronized (list) {
            markedChannels.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushAllChannels() {
        List<ChannelOutboundInvoker> list = markedChannels;
        synchronized (list) {
            markedChannels.forEach(ChannelOutboundInvoker::flush);
            markedChannels.clear();
        }
    }

    private static boolean isInstantFlushEnabled() {
        return false;
    }

    static {
        Thread thread = new Thread((Runnable)new NetworkChannelHelper(), "NetworkChannelFlush");
        thread.setDaemon(true);
        thread.start();
    }
}

