/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.forge.fml.common;

import com.google.common.collect.Maps;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.bridge.fml.common.LoaderBridge;
import io.github.lxgaming.sledgehammer.manager.MappingManager;
import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Loader.class}, priority=1337, remap=false)
public abstract class LoaderMixin
implements LoaderBridge {
    @Shadow
    private ModClassLoader modClassLoader;
    @Shadow
    private static File minecraftDir;
    private final Map<File, Set<String>> sledgehammer$mappings = Maps.newHashMap();

    @Inject(method={"identifyMods"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraftforge/fml/relauncher/libraries/LibraryManager;gatherLegacyCanidates(Ljava/io/File;)Ljava/util/List;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onGatherLegacyCanidates(List<String> additionalContainers, CallbackInfoReturnable<ModDiscoverer> callbackInfoReturnable, ModDiscoverer discoverer, List<Artifact> maven_canidates, List<File> file_canidates) {
        block0: for (Map.Entry<File, Set<String>> entry : this.sledgehammer$mappings.entrySet()) {
            if (CoreModManager.getReparseableCoremods().contains(entry.getKey().getName())) continue;
            for (String id : entry.getValue()) {
                if (!MappingManager.getModMapping(id).isPresent()) continue;
                file_canidates.removeIf(entry.getKey()::equals);
                maven_canidates.removeIf(artifact -> ((File)entry.getKey()).equals(artifact.getFile()));
                continue block0;
            }
        }
        this.sledgehammer$mappings.clear();
    }

    @Override
    public void bridge$addFile(File file) {
        try {
            if (this.modClassLoader.containsSource(file)) {
                return;
            }
            this.modClassLoader.addFile(file);
            Sledgehammer.getInstance().getLogger().info("Loaded {}", (Object)file.getName());
        }
        catch (MalformedURLException ex) {
            Sledgehammer.getInstance().getLogger().error("Encountered an error while adding {} to the classloader", (Object)file, (Object)ex);
        }
    }

    @Override
    public File bridge$getMinecraftDirectory() {
        return minecraftDir;
    }

    @Override
    public Map<File, Set<String>> bridge$getMappings() {
        return this.sledgehammer$mappings;
    }
}

