/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.annotation.Mapping;
import io.github.lxgaming.sledgehammer.configuration.category.GeneralCategory;
import io.github.lxgaming.sledgehammer.configuration.category.MixinCategory;
import io.github.lxgaming.sledgehammer.launch.SledgehammerLaunch;
import io.github.lxgaming.sledgehammer.util.StringUtils;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;

public final class MappingManager {
    public static final Map<String, Boolean> MIXIN_MAPPINGS = Maps.newHashMap();
    public static final Map<String, Boolean> MOD_MAPPINGS = Maps.newHashMap();
    public static final Map<Class<?>, SledgehammerPlatform.State> STATE_MAPPINGS = Maps.newHashMap();

    public static void prepare() {
        Sledgehammer.getInstance().getConfig().map(Config::getGeneralCategory).map(GeneralCategory::getModMappings).ifPresent(MOD_MAPPINGS::putAll);
        MixinCategory mixinCategory = Sledgehammer.getInstance().getConfig().map(Config::getMixinCategory).orElseThrow(NullPointerException::new);
        for (Field field : mixinCategory.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                MappingManager.registerMixinMappings(field.get(mixinCategory));
            }
            catch (Exception ex) {
                Sledgehammer.getInstance().getLogger().error("Encountered an error while registering {} ({})", (Object)Toolbox.getClassSimpleName(field.getType()), (Object)field.getName());
            }
        }
        MIXIN_MAPPINGS.put("core.client.MinecraftMixin", true);
        MIXIN_MAPPINGS.put("core.crash.CrashReportMixin", true);
        MIXIN_MAPPINGS.put("core.server.DedicatedServerMixin", true);
        MIXIN_MAPPINGS.put("core.util.text.TextFormattingMixin", true);
        MIXIN_MAPPINGS.put("forge.fml.common.LoaderMixin", SledgehammerLaunch.isForgeInitialized() && !MOD_MAPPINGS.isEmpty());
        MIXIN_MAPPINGS.put("forge.fml.common.MetadataCollectionAccessor", SledgehammerLaunch.isForgeInitialized() && !MOD_MAPPINGS.isEmpty());
        MIXIN_MAPPINGS.put("platform.SledgehammerPlatformMixin_Mod", SledgehammerLaunch.isForgeInitialized() && !SledgehammerLaunch.isSpongeInitialized());
        MIXIN_MAPPINGS.put("platform.SledgehammerPlatformMixin_Plugin", SledgehammerLaunch.isSpongeInitialized());
    }

    private static void registerMixinMappings(Object object) throws Exception {
        Preconditions.checkNotNull((Object)object);
        for (Field field : object.getClass().getDeclaredFields()) {
            Mapping[] mappings = (Mapping[])field.getDeclaredAnnotationsByType(Mapping.class);
            if (mappings.length == 0) continue;
            field.setAccessible(true);
            boolean value = field.getBoolean(object);
            for (Mapping mapping : mappings) {
                if (value) {
                    MappingManager.registerModMappings(mapping.dependencies());
                }
                if (MIXIN_MAPPINGS.getOrDefault(mapping.value(), false).booleanValue()) continue;
                MIXIN_MAPPINGS.put(mapping.value(), value);
            }
        }
    }

    private static void registerModMappings(String ... dependencies) {
        Preconditions.checkNotNull((Object)dependencies);
        for (String dependency : dependencies) {
            MOD_MAPPINGS.putIfAbsent(dependency, true);
        }
    }

    public static Optional<Boolean> getMixinMapping(String mixin) {
        return Optional.ofNullable(MIXIN_MAPPINGS.get(StringUtils.removeStart((String)mixin, (String)"io.github.lxgaming.sledgehammer.mixin.")));
    }

    public static Optional<Boolean> getModMapping(String mod) {
        return Optional.ofNullable(MOD_MAPPINGS.get(mod));
    }

    public static Optional<SledgehammerPlatform.State> getStateMapping(Class<?> stateClass) {
        for (Map.Entry<Class<?>, SledgehammerPlatform.State> entry : STATE_MAPPINGS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(stateClass)) continue;
            return Optional.ofNullable(entry.getValue());
        }
        return Optional.empty();
    }
}

