/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.manager;

import com.google.common.collect.Sets;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.category.IntegrationCategory;
import io.github.lxgaming.sledgehammer.integration.Integration;
import io.github.lxgaming.sledgehammer.integration.botania.BotaniaIntegration;
import io.github.lxgaming.sledgehammer.integration.forge.ForgeIntegration_Permission;
import io.github.lxgaming.sledgehammer.integration.forge.ForgeIntegration_Recipe;
import io.github.lxgaming.sledgehammer.integration.mist.MistIntegration;
import io.github.lxgaming.sledgehammer.integration.primal.PrimalIntegration;
import io.github.lxgaming.sledgehammer.integration.sledgehammer.CommandIntegration;
import io.github.lxgaming.sledgehammer.integration.sponge.SpongeIntegration_Border;
import io.github.lxgaming.sledgehammer.integration.sponge.SpongeIntegration_Death;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

public final class IntegrationManager {
    public static final Set<Integration> INTEGRATIONS = Sets.newLinkedHashSet();
    private static final Set<Class<? extends Integration>> INTEGRATION_CLASSES = Sets.newHashSet();

    public static void prepare() {
        IntegrationManager.registerIntegration(CommandIntegration.class, category -> true);
        IntegrationManager.registerIntegration(BotaniaIntegration.class, category -> category.getBotaniaIntegrationCategory().isIslandCreation());
        IntegrationManager.registerIntegration(ForgeIntegration_Permission.class, category -> category.getForgeIntegrationCategory().isCheckPermissions());
        IntegrationManager.registerIntegration(ForgeIntegration_Recipe.class, category -> !category.getForgeIntegrationCategory().getBlacklistedRecipeItems().isEmpty());
        IntegrationManager.registerIntegration(MistIntegration.class, category -> category.getMistIntegrationCategory().isPortal());
        IntegrationManager.registerIntegration(PrimalIntegration.class, category -> category.getPrimalIntegrationCategory().isFlake());
        IntegrationManager.registerIntegration(SpongeIntegration_Border.class, category -> category.getSpongeIntegrationCategory().isBorder());
        IntegrationManager.registerIntegration(SpongeIntegration_Death.class, category -> category.getSpongeIntegrationCategory().isDeath());
    }

    public static void execute() {
        SledgehammerPlatform.State state = SledgehammerPlatform.getInstance().getState();
        for (Integration integration : INTEGRATIONS) {
            if (integration.getState() != state) continue;
            LinkedHashSet missingDependencies = Sets.newLinkedHashSet();
            for (String dependency : integration.getDependencies()) {
                if (SledgehammerPlatform.getInstance().isLoaded(dependency)) continue;
                missingDependencies.add(dependency);
            }
            if (!missingDependencies.isEmpty()) {
                Sledgehammer.getInstance().getLogger().warn("{} is missing the following dependencies: {}", (Object)Toolbox.getClassSimpleName(integration.getClass()), (Object)String.join((CharSequence)", ", missingDependencies));
                continue;
            }
            Sledgehammer.getInstance().getLogger().debug("Processing {} ({})", (Object)Toolbox.getClassSimpleName(integration.getClass()), (Object)state);
            try {
                integration.execute();
            }
            catch (Exception ex) {
                Sledgehammer.getInstance().getLogger().error("Encountered an error while executing {}", (Object)Toolbox.getClassSimpleName(integration.getClass()), (Object)ex);
            }
        }
    }

    private static boolean registerIntegration(Class<? extends Integration> integrationClass, Function<IntegrationCategory, Boolean> function) {
        if (INTEGRATION_CLASSES.contains(integrationClass)) {
            Sledgehammer.getInstance().getLogger().warn("{} is already registered", (Object)Toolbox.getClassSimpleName(integrationClass));
            return false;
        }
        INTEGRATION_CLASSES.add(integrationClass);
        if (!Sledgehammer.getInstance().getConfig().map(Config::getIntegrationCategory).map(function).orElse(false).booleanValue()) {
            return false;
        }
        Integration integration = Toolbox.newInstance(integrationClass);
        if (integration == null) {
            Sledgehammer.getInstance().getLogger().error("{} failed to initialize", (Object)Toolbox.getClassSimpleName(integrationClass));
            return false;
        }
        if (!integration.prepare()) {
            Sledgehammer.getInstance().getLogger().warn("{} failed to prepare", (Object)Toolbox.getClassSimpleName(integrationClass));
            return false;
        }
        INTEGRATIONS.add(integration);
        Sledgehammer.getInstance().getLogger().debug("{} registered", (Object)Toolbox.getClassSimpleName(integrationClass));
        return true;
    }
}

