/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.config.impl;

import io.github.lxgaming.sledgehammer.lib.config.ConfigException;
import io.github.lxgaming.sledgehammer.lib.config.impl.AbstractConfigNodeValue;
import io.github.lxgaming.sledgehammer.lib.config.impl.AbstractConfigValue;
import io.github.lxgaming.sledgehammer.lib.config.impl.ConfigReference;
import io.github.lxgaming.sledgehammer.lib.config.impl.ConfigString;
import io.github.lxgaming.sledgehammer.lib.config.impl.Path;
import io.github.lxgaming.sledgehammer.lib.config.impl.PathParser;
import io.github.lxgaming.sledgehammer.lib.config.impl.SubstitutionExpression;
import io.github.lxgaming.sledgehammer.lib.config.impl.Token;
import io.github.lxgaming.sledgehammer.lib.config.impl.Tokens;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConfigNodeSimpleValue
extends AbstractConfigNodeValue {
    final Token token;

    ConfigNodeSimpleValue(Token value) {
        this.token = value;
    }

    @Override
    protected Collection<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    protected Token token() {
        return this.token;
    }

    protected AbstractConfigValue value() {
        if (Tokens.isValue(this.token)) {
            return Tokens.getValue(this.token);
        }
        if (Tokens.isUnquotedText(this.token)) {
            return new ConfigString.Unquoted(this.token.origin(), Tokens.getUnquotedText(this.token));
        }
        if (Tokens.isSubstitution(this.token)) {
            List<Token> expression = Tokens.getSubstitutionPathExpression(this.token);
            Path path = PathParser.parsePathExpression(expression.iterator(), this.token.origin());
            boolean optional = Tokens.getSubstitutionOptional(this.token);
            return new ConfigReference(this.token.origin(), new SubstitutionExpression(path, optional));
        }
        throw new ConfigException.BugOrBroken("ConfigNodeSimpleValue did not contain a valid value token");
    }
}

