/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.integration.mist;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.integration.Integration;
import io.github.lxgaming.sledgehammer.util.StringUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.trait.BlockTrait;
import org.spongepowered.api.block.trait.BooleanTrait;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.TickBlockEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class MistIntegration
extends Integration {
    @Override
    public boolean prepare() {
        this.addDependency("forge");
        this.addDependency("mist");
        this.addDependency("sponge");
        this.state(SledgehammerPlatform.State.INITIALIZATION);
        return true;
    }

    @Override
    public void execute() throws Exception {
        Sponge.getEventManager().registerListeners(SledgehammerPlatform.getInstance().getContainer(), (Object)this);
    }

    @Listener(order=Order.LATE)
    public void onTickBlock(TickBlockEvent.Scheduled event, @Getter(value="getTargetBlock") BlockSnapshot blockSnapshot) {
        if (!StringUtils.equals((CharSequence)blockSnapshot.getState().getType().getId(), (CharSequence)"mist:portal")) {
            return;
        }
        Location location = blockSnapshot.getLocation().orElse(null);
        if (location != null && this.isValidPortalBlock(location.getBlockRelative(Direction.DOWN).getBlock()) && this.isValidPortalBlock(location.getBlockRelative(Direction.UP).getBlock())) {
            event.setCancelled(true);
            Sledgehammer.getInstance().debug("Portal Tick Cancelled {}", location.getBlockPosition().toString());
        }
    }

    @Listener(order=Order.LATE)
    public void onChangeBlockBreak(ChangeBlockEvent.Break event) {
        for (Transaction transaction : event.getTransactions()) {
            BlockTrait blockTrait;
            if (!this.isValidPortalBlock(((BlockSnapshot)transaction.getOriginal()).getState()) || !((blockTrait = (BlockTrait)((BlockSnapshot)transaction.getOriginal()).getState().getTrait("isup").orElse(null)) instanceof BooleanTrait)) continue;
            if (((BlockSnapshot)transaction.getOriginal()).getState().getTraitValue((BlockTrait)((BooleanTrait)blockTrait)).orElse(false).booleanValue()) {
                ((BlockSnapshot)transaction.getOriginal()).getLocation().ifPresent(location -> ((World)location.getExtent()).addScheduledUpdate(location.getBlockRelative(Direction.DOWN).getBlockPosition(), 1, 1));
                continue;
            }
            ((BlockSnapshot)transaction.getOriginal()).getLocation().ifPresent(location -> ((World)location.getExtent()).addScheduledUpdate(location.getBlockRelative(Direction.UP).getBlockPosition(), 1, 1));
        }
    }

    @Listener(order=Order.LATE)
    public void onChangeBlockPlace(ChangeBlockEvent.Place event) {
        for (Transaction transaction : event.getTransactions()) {
            Location location;
            if (!StringUtils.equals((CharSequence)((BlockSnapshot)transaction.getFinal()).getState().getType().getId(), (CharSequence)"minecraft:gold_block") || (location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().orElse(null)) == null || !this.isValidPortalBlock(location.getBlockRelative(Direction.DOWN).getBlock()) || !this.isValidPortalBlock(location.getBlockRelative(Direction.UP).getBlock())) continue;
            ((World)location.getExtent()).addScheduledUpdate(location.getBlockRelative(Direction.UP).getBlockPosition(), 1, 1);
        }
    }

    private boolean isValidPortalBlock(BlockState blockState) {
        if (!StringUtils.equals((CharSequence)blockState.getType().getId(), (CharSequence)"mist:portal_base") && !StringUtils.equals((CharSequence)blockState.getType().getId(), (CharSequence)"mist:portal_work")) {
            return false;
        }
        return blockState.getTrait("isnew").isPresent() && blockState.getTrait("isup").isPresent();
    }
}

