/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.jee.integration;

import appeng.container.implementations.ContainerPatternTerm;
import appeng.util.Platform;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.collect.Table;
import mezz.jei.recipes.RecipeTransferRegistry;
import mezz.jei.startup.StackHelper;
import mezz.jei.transfer.RecipeTransferErrorInternal;
import mezz.jei.transfer.RecipeTransferErrorTooltip;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import p455w0rd.jee.init.ModLogger;
import p455w0rd.jee.init.ModNetworking;
import p455w0rd.jee.packets.PacketJEIPatternRecipe;
import p455w0rd.jee.util.WrappedTable;

@JEIPlugin
public class JEI
implements IModPlugin {
    private static final IRecipeTransferError NEEDED_MODE_CRAFTING = new IncorrectTerminalModeError(true);
    private static final IRecipeTransferError NEEDED_MODE_PROCESSING = new IncorrectTerminalModeError(false);
    private static StackHelper stackHelper = null;

    public void register(@Nonnull IModRegistry registry) {
        IStackHelper ish = registry.getJeiHelpers().getStackHelper();
        if (ish instanceof StackHelper) {
            stackHelper = (StackHelper)registry.getJeiHelpers().getStackHelper();
        }
        WrappedTable newRegistry = Table.hashBasedTable();
        boolean ae2found = false;
        for (Table.Cell currentCell : ((RecipeTransferRegistry)registry.getRecipeTransferRegistry()).getRecipeTransferHandlers().cellSet()) {
            if (((Class)currentCell.getRowKey()).equals(ContainerPatternTerm.class)) {
                ae2found = true;
                continue;
            }
            newRegistry.put(currentCell.getRowKey(), currentCell.getColumnKey(), currentCell.getValue());
        }
        newRegistry.put(ContainerPatternTerm.class, "universal recipe transfer handler", new RecipeTransferHandler());
        if (ae2found) {
            ModLogger.info("AE2 RecipeTransferHandler Replaced Successfully (Registered prior)");
        } else {
            newRegistry = new WrappedTable(newRegistry);
        }
        ReflectionHelper.setPrivateValue(RecipeTransferRegistry.class, (Object)((RecipeTransferRegistry)registry.getRecipeTransferRegistry()), newRegistry, (String[])new String[]{"recipeTransferHandlers"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public static StackHelper getStackHelper() {
        return stackHelper;
    }

    private static class IncorrectTerminalModeError
    extends RecipeTransferErrorTooltip {
        private static final String CRAFTING = I18n.func_74837_a((String)"tooltip.jee.crafting", (Object[])new Object[0]);
        private static final String PROCESSING = I18n.func_74837_a((String)"tooltip.jee.processing", (Object[])new Object[0]);

        public IncorrectTerminalModeError(boolean needsCrafting) {
            super(I18n.func_74837_a((String)"tooltip.jee.errormsg", (Object[])new Object[]{TextFormatting.BOLD + (needsCrafting ? CRAFTING : PROCESSING) + TextFormatting.RESET + "" + TextFormatting.RED}));
        }
    }

    public static class RecipeTransferHandler
    implements IRecipeTransferHandler<ContainerPatternTerm> {
        public static final String OUTPUTS_KEY = "Outputs";

        public Class<ContainerPatternTerm> getContainerClass() {
            return ContainerPatternTerm.class;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(ContainerPatternTerm container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
            String recipeType = recipeLayout.getRecipeCategory().getUid();
            if (doTransfer) {
                Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
                NBTTagCompound recipeInputs = new NBTTagCompound();
                NBTTagCompound recipeOutputs = null;
                NBTTagList outputList = new NBTTagList();
                int inputIndex = 0;
                int outputIndex = 0;
                for (Map.Entry ingredientEntry : ingredients.entrySet()) {
                    IGuiIngredient guiIngredient = (IGuiIngredient)ingredientEntry.getValue();
                    if (guiIngredient == null) continue;
                    ItemStack ingredient = ItemStack.field_190927_a;
                    if (guiIngredient.getDisplayedIngredient() != null) {
                        ingredient = ((ItemStack)guiIngredient.getDisplayedIngredient()).func_77946_l();
                    }
                    if (guiIngredient.isInput()) {
                        List currentList = guiIngredient.getAllIngredients();
                        ItemStack stack = currentList.isEmpty() ? ItemStack.field_190927_a : (ItemStack)currentList.get(0);
                        for (ItemStack currentStack : currentList) {
                            if (currentStack == null || !Platform.isRecipePrioritized((ItemStack)currentStack)) continue;
                            stack = currentStack.func_77946_l();
                        }
                        if (stack == null) {
                            stack = ItemStack.field_190927_a;
                        }
                        recipeInputs.func_74782_a("#" + inputIndex, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
                        ++inputIndex;
                        continue;
                    }
                    if (outputIndex >= 3 || ingredient.func_190926_b() || container.isCraftingMode()) continue;
                    outputList.func_74742_a((NBTBase)ingredient.func_77955_b(new NBTTagCompound()));
                    ++outputIndex;
                }
                if (!outputList.func_82582_d()) {
                    recipeOutputs = new NBTTagCompound();
                    recipeOutputs.func_74782_a(OUTPUTS_KEY, (NBTBase)outputList);
                }
                ModNetworking.getInstance().sendToServer((IMessage)new PacketJEIPatternRecipe(recipeInputs, recipeOutputs));
            }
            if (!recipeType.equals("jei.information") && !recipeType.equals("minecraft.fuel")) {
                if (!container.isCraftingMode()) {
                    if (recipeType.equals("minecraft.crafting")) {
                        return NEEDED_MODE_CRAFTING;
                    }
                } else if (!recipeType.equals("minecraft.crafting")) {
                    return NEEDED_MODE_PROCESSING;
                }
            } else {
                return RecipeTransferErrorInternal.INSTANCE;
            }
            return null;
        }
    }
}

