/*
 * Decompiled with CFR 0.152.
 */
package thecodewarrior.hooked.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import thecodewarrior.hooked.HookedMod;
import thecodewarrior.hooked.client.ModelHandle;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rJ\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lthecodewarrior/hooked/client/ModelHandle;", "", "loc", "Lnet/minecraft/util/ResourceLocation;", "(Lnet/minecraft/util/ResourceLocation;)V", "isMissing", "", "()Z", "getLoc", "()Lnet/minecraft/util/ResourceLocation;", "get", "Lnet/minecraft/client/renderer/block/model/IBakedModel;", "getResources", "", "load", "purge", "", "reload", "Companion", "hooked"})
public final class ModelHandle {
    @NotNull
    private final ResourceLocation loc;
    @NotNull
    private static Map<ResourceLocation, IBakedModel> cache;
    @NotNull
    private static Map<ResourceLocation, Collection<ResourceLocation>> resourceCache;
    @NotNull
    private static Set<ResourceLocation> missingModels;
    @NotNull
    private static Map<ResourceLocation, List<String>> errors;
    public static final Companion Companion;

    @NotNull
    public final IBakedModel get() {
        return ModelHandle.Companion.getModel(this.loc);
    }

    @NotNull
    public final Collection<ResourceLocation> getResources() {
        this.get();
        Collection collection = resourceCache.get(this.loc);
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @NotNull
    public final ModelHandle load() {
        ModelHandle.Companion.getModel(this.loc);
        return this;
    }

    public final void purge() {
        cache.remove(this.loc);
        resourceCache.remove(this.loc);
        missingModels.remove(this.loc);
        errors.remove(this.loc);
    }

    @NotNull
    public final ModelHandle reload() {
        ModelHandle.Companion.loadModel(this.loc);
        return this;
    }

    public final boolean isMissing() {
        ModelHandle.Companion.getModel(this.loc);
        return missingModels.contains(this.loc);
    }

    @NotNull
    public final ResourceLocation getLoc() {
        return this.loc;
    }

    public ModelHandle(@NotNull ResourceLocation loc) {
        Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
        this.loc = loc;
    }

    static {
        Companion = new Companion(null);
        cache = new LinkedHashMap();
        resourceCache = new LinkedHashMap();
        missingModels = new LinkedHashSet();
        errors = new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\rJ\u000e\u0010\"\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u0005R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR,\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\nR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R,\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00170\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\n\u00a8\u0006#"}, d2={"Lthecodewarrior/hooked/client/ModelHandle$Companion;", "", "()V", "cache", "", "Lnet/minecraft/util/ResourceLocation;", "Lnet/minecraft/client/renderer/block/model/IBakedModel;", "getCache", "()Ljava/util/Map;", "setCache", "(Ljava/util/Map;)V", "errors", "", "", "getErrors", "setErrors", "missingModels", "", "getMissingModels", "()Ljava/util/Set;", "setMissingModels", "(Ljava/util/Set;)V", "resourceCache", "", "getResourceCache", "setResourceCache", "getModel", "loc", "init", "", "loadModel", "of", "Lthecodewarrior/hooked/client/ModelHandle;", "model", "ofLazy", "hooked"})
    public static final class Companion {
        @NotNull
        protected final Map<ResourceLocation, IBakedModel> getCache() {
            return cache;
        }

        protected final void setCache(@NotNull Map<ResourceLocation, IBakedModel> map) {
            Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
            cache = map;
        }

        @NotNull
        protected final Map<ResourceLocation, Collection<ResourceLocation>> getResourceCache() {
            return resourceCache;
        }

        protected final void setResourceCache(@NotNull Map<ResourceLocation, Collection<ResourceLocation>> map) {
            Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
            resourceCache = map;
        }

        @NotNull
        protected final Set<ResourceLocation> getMissingModels() {
            return missingModels;
        }

        protected final void setMissingModels(@NotNull Set<ResourceLocation> set) {
            Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
            missingModels = set;
        }

        @NotNull
        protected final Map<ResourceLocation, List<String>> getErrors() {
            return errors;
        }

        protected final void setErrors(@NotNull Map<ResourceLocation, List<String>> map) {
            Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
            errors = map;
        }

        @NotNull
        public final ModelHandle of(@NotNull String model) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            return this.of(new ResourceLocation(model));
        }

        @NotNull
        public final ModelHandle ofLazy(@NotNull String model) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            return this.ofLazy(new ResourceLocation(model));
        }

        @NotNull
        public final ModelHandle ofLazy(@NotNull ResourceLocation loc) {
            Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
            return new ModelHandle(loc);
        }

        @NotNull
        public final ModelHandle of(@NotNull ResourceLocation loc) {
            Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
            return new ModelHandle(loc).reload();
        }

        private final IBakedModel getModel(ResourceLocation loc) {
            IBakedModel model = this.getCache().get(loc);
            if (model != null) {
                return model;
            }
            this.loadModel(loc);
            model = this.getCache().get(loc);
            if (model == null) {
                throw (Throwable)new IllegalStateException("Cache contained null even after loading for model " + loc);
            }
            return model;
        }

        private final void loadModel(ResourceLocation loc) {
            try {
                IModel mod;
                IModel iModel;
                if (HookedMod.DEV_ENVIRONMENT) {
                    IModel m;
                    IModel iModel2;
                    try {
                        iModel2 = ModelLoaderRegistry.getModel((ResourceLocation)loc);
                    }
                    catch (Exception e) {
                        Map<ResourceLocation, List<String>> $receiver$iv = this.getErrors();
                        List<String> value$iv = $receiver$iv.get(loc);
                        if (value$iv == null) {
                            List answer$iv = new ArrayList();
                            $receiver$iv.put(loc, answer$iv);
                        }
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        List<String> list = this.getErrors().get(loc);
                        if (list != null) {
                            String string = sw.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
                            list.add(string);
                        }
                        iModel2 = ModelLoaderRegistry.getMissingModel();
                    }
                    iModel = m = iModel2;
                } else {
                    iModel = mod = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)loc);
                }
                if (mod == ModelLoaderRegistry.getMissingModel()) {
                    this.getMissingModels().add(loc);
                }
                IModel iModel3 = mod;
                Intrinsics.checkExpressionValueIsNotNull((Object)iModel3, (String)"mod");
                IBakedModel model = mod.bake(iModel3.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                Map<ResourceLocation, IBakedModel> map = this.getCache();
                IBakedModel iBakedModel = model;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBakedModel, (String)"model");
                map.put(loc, iBakedModel);
                Map<ResourceLocation, Collection<ResourceLocation>> map2 = this.getResourceCache();
                Collection collection = mod.getTextures();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"mod.textures");
                map2.put(loc, collection);
            }
            catch (Exception e) {
                throw (Throwable)new ReportedException(new CrashReport("Error loading custom model " + loc, (Throwable)e));
            }
        }

        public final void init() {
            Minecraft minecraft = Minecraft.func_71410_x();
            Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
            IResourceManager rm = minecraft.func_110442_L();
            if (rm instanceof IReloadableResourceManager) {
                ((IReloadableResourceManager)rm).func_110542_a((IResourceManagerReloadListener)init.1.INSTANCE);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

