/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.tileentity;

import java.util.ArrayList;
import mal.lootbags.LootBags;
import mal.lootbags.handler.BagHandler;
import mal.lootbags.item.LootbagItem;
import mal.lootbags.network.LootbagsPacketHandler;
import mal.lootbags.network.message.StorageMessageClient;
import mal.lootbags.network.message.StorageMessageServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityStorage
extends TileEntity
implements IInventory,
ISidedInventory,
ITickable {
    private int stored_value;
    private int outputID;
    private int outputindex;
    private ItemStack input_inventory = ItemStack.field_190927_a;
    private ArrayList<Integer> outputIDlist = new ArrayList();
    private boolean justRemoved = false;
    private NetworkRegistry.TargetPoint point;

    public TileEntityStorage() {
        this.outputIDlist.addAll(BagHandler.getExtractedBagList());
        this.outputindex = 0;
        this.outputID = this.outputIDlist.get(this.outputindex);
    }

    public void activate(World world, BlockPos pos, EntityPlayer player) {
        player.openGui((Object)LootBags.LootBagsInstance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.point == null) {
                this.point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 16.0);
            }
            LootbagsPacketHandler.instance.sendToAllAround((IMessage)new StorageMessageServer(this, this.stored_value, this.outputID, this.outputindex), this.point);
        }
        this.justRemoved = false;
    }

    public void setDataClient(int value, int ID, int index) {
        this.stored_value = value;
        this.outputID = ID;
        this.outputindex = index;
    }

    public void setDataServer(int ID, int index) {
        this.outputID = ID;
        this.outputindex = index;
        this.func_70296_d();
    }

    public void setOutputID(int ID) {
        if (!BagHandler.isIDFree(ID)) {
            this.outputID = ID;
        }
    }

    public void cycleOutputID(boolean direction) {
        if (direction) {
            ++this.outputindex;
            if (this.outputindex == this.outputIDlist.size()) {
                this.outputindex = 0;
            }
        } else {
            --this.outputindex;
            if (this.outputindex < 0) {
                this.outputindex = this.outputIDlist.size() - 1;
            }
        }
        try {
            this.outputID = this.outputIDlist.get(this.outputindex);
        }
        catch (IndexOutOfBoundsException e) {
            this.outputID = this.outputIDlist.get(0);
            this.outputindex = 0;
        }
        if (this.field_145850_b.field_72995_K) {
            LootbagsPacketHandler.instance.sendToServer((IMessage)new StorageMessageClient(this, this.outputID, this.outputindex));
        }
    }

    public int getStorage() {
        return this.stored_value;
    }

    public ItemStack getOutputStack() {
        return new ItemStack((Item)LootBags.lootbagItem, 1, this.outputID);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputID = nbt.func_74762_e("outputID");
        this.stored_value = nbt.func_74762_e("totalValue");
        this.outputindex = nbt.func_74762_e("outputindex");
        NBTTagList input = nbt.func_150295_c("inputItems", 10);
        NBTTagCompound var4 = input.func_150305_b(0);
        this.input_inventory = new ItemStack(var4);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("outputID", this.outputID);
        nbt.func_74768_a("totalValue", this.stored_value);
        nbt.func_74768_a("outputindex", this.outputindex);
        NBTTagList input = new NBTTagList();
        NBTTagCompound var4 = new NBTTagCompound();
        this.input_inventory.func_77955_b(var4);
        input.func_74742_a((NBTBase)var4);
        nbt.func_74782_a("inputItems", (NBTBase)input);
        return nbt;
    }

    public NBTTagCompound getDropNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("outputID", this.outputID);
        tag.func_74768_a("stored_value", this.stored_value);
        tag.func_74768_a("outputindex", this.outputindex);
        return tag;
    }

    public boolean removeBag() {
        int value = BagHandler.getBagValue(this.outputID)[1];
        if (this.stored_value >= value) {
            this.stored_value -= value;
            this.justRemoved = true;
            return true;
        }
        return false;
    }

    public String func_70005_c_() {
        return "storage";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (!(itemStackIn.func_77973_b() instanceof LootbagItem)) {
            return false;
        }
        if (LootBags.PREVENTMERGEDBAGS) {
            if (!BagHandler.isBagOpened(itemStackIn) && BagHandler.isBagInsertable(itemStackIn.func_77960_j())) {
                return this.stored_value + BagHandler.getBagValue(itemStackIn.func_77960_j())[0] != Integer.MAX_VALUE && this.stored_value + BagHandler.getBagValue(itemStackIn.func_77960_j())[0] >= 0;
            }
        } else if (BagHandler.isBagInsertable(itemStackIn.func_77960_j())) {
            return this.stored_value + BagHandler.getBagValue(itemStackIn.func_77960_j())[0] != Integer.MAX_VALUE && this.stored_value + BagHandler.getBagValue(itemStackIn.func_77960_j())[0] >= 0;
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int index) {
        if (index == 0) {
            if (this.stored_value >= BagHandler.getBagValue(this.outputID)[1] || this.justRemoved) {
                if (LootBags.STOREDCOUNT) {
                    String ss;
                    if (LootBags.MEKOVERRIDE && (ss = new Throwable().getStackTrace()[1].getClassName()).startsWith("mekanism")) {
                        return new ItemStack((Item)LootBags.lootbagItem, 1, this.outputID);
                    }
                    return new ItemStack((Item)LootBags.lootbagItem, (int)Math.floor(this.stored_value / BagHandler.getBagValue(this.outputID)[1]), this.outputID);
                }
                return new ItemStack((Item)LootBags.lootbagItem, 1, this.outputID);
            }
            return ItemStack.field_190927_a;
        }
        return this.input_inventory;
    }

    public ItemStack func_70298_a(int slot, int dec) {
        if (slot == 0) {
            int value = BagHandler.getBagValue(this.outputID)[1];
            if (this.stored_value >= value) {
                this.stored_value -= value;
                return new ItemStack((Item)LootBags.lootbagItem, 1, this.outputID);
            }
        } else if (this.input_inventory != null) {
            if (this.input_inventory.func_190916_E() <= dec) {
                ItemStack is = this.input_inventory;
                this.input_inventory = ItemStack.field_190927_a;
                return is;
            }
            ItemStack is = this.input_inventory.func_77979_a(dec);
            if (this.input_inventory.func_190916_E() == 0) {
                this.input_inventory = ItemStack.field_190927_a;
            }
            return is;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        int value;
        if (index == 0 && this.stored_value >= (value = BagHandler.getBagValue(this.outputID)[1])) {
            this.stored_value -= value;
            return new ItemStack((Item)LootBags.lootbagItem, 1, this.outputID);
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof LootbagItem)) {
            if (this.stored_value < BagHandler.getBagValue(this.outputID)[1]) {
                return;
            }
            this.stored_value -= BagHandler.getBagValue(this.outputID)[1];
            return;
        }
        int value = BagHandler.getBagValue(stack)[0];
        if (value < 1) {
            return;
        }
        this.stored_value += value;
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof LootbagItem)) {
            return false;
        }
        if (LootBags.PREVENTMERGEDBAGS) {
            if (!BagHandler.isBagOpened(stack) && BagHandler.isBagInsertable(stack.func_77960_j())) {
                return this.stored_value + BagHandler.getBagValue(stack.func_77960_j())[0] < Integer.MAX_VALUE && this.stored_value + BagHandler.getBagValue(stack.func_77960_j())[0] >= 0;
            }
        } else if (BagHandler.isBagInsertable(stack.func_77960_j())) {
            return this.stored_value + BagHandler.getBagValue(stack.func_77960_j())[0] < Integer.MAX_VALUE && this.stored_value + BagHandler.getBagValue(stack.func_77960_j())[0] >= 0;
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new SidedInvWrapper((ISidedInventory)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getID() {
        return this.outputID;
    }

    public void decrStorage(ItemStack is) {
        if (is != null && !is.func_190926_b() && is.func_77973_b() instanceof LootbagItem) {
            int value = BagHandler.getBagValue(is.func_77960_j())[1];
            this.stored_value = this.stored_value >= value ? (this.stored_value -= value) : 0;
        }
    }
}

