/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import mal.lootbags.Bag;
import mal.lootbags.LootBags;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.item.LootbagItem;
import mal.lootbags.loot.LootItem;
import net.minecraft.item.ItemStack;

public class BagHandler {
    private static HashMap<Integer, Bag> bagList = new HashMap();
    private static ArrayList<Integer> storableinputIDs = new ArrayList();
    private static ArrayList<Integer> storableoutputIDs = new ArrayList();
    public static final int HARDMAX = 5;

    public static void clearBags() {
        bagList = new HashMap();
        storableinputIDs = new ArrayList();
        storableoutputIDs = new ArrayList();
    }

    public static void addBag(Bag bag) {
        bagList.put(bag.getBagIndex(), bag);
        if (bag.isStorable().canInput()) {
            storableinputIDs.add(bag.getBagIndex());
        }
        if (bag.isStorable().canOutput()) {
            storableoutputIDs.add(bag.getBagIndex());
        }
        LootbagsUtil.LogDebug("Added bag: " + bag.getBagName() + " with ID: " + bag.getBagIndex() + ".");
    }

    public static Bag getBag(int index) {
        if (!BagHandler.isIDFree(index)) {
            return bagList.get(index);
        }
        return null;
    }

    public static Bag getBag(String name) {
        for (Bag b : bagList.values()) {
            if (!b.getBagName().equalsIgnoreCase(name)) continue;
            return b;
        }
        return null;
    }

    public static boolean isIDFree(int ID) {
        return !bagList.containsKey(ID);
    }

    public static HashMap<Integer, Bag> getBagList() {
        return bagList;
    }

    public static void populateBagLists() {
        for (Bag bag : bagList.values()) {
            if (bag == null) continue;
            bag.populateBag();
        }
    }

    public static int getLowestUsedID() {
        int ID = Integer.MAX_VALUE;
        for (Bag bag : bagList.values()) {
            if (bag.getBagIndex() >= ID) continue;
            ID = bag.getBagIndex();
        }
        return ID;
    }

    public static int getHighestUsedID() {
        int ID = -1;
        for (Bag bag : bagList.values()) {
            if (bag.getBagIndex() <= ID) continue;
            ID = bag.getBagIndex();
        }
        return ID;
    }

    public static ArrayList<LootItem> generateContent(Collection<LootItem> collection) {
        ArrayList<LootItem> list = new ArrayList<LootItem>();
        for (LootItem c : collection) {
            list.add(c);
        }
        return list;
    }

    public static boolean isBagEmpty(int ID) {
        if (BagHandler.isIDFree(ID)) {
            return true;
        }
        return bagList.get(ID).isBagEmpty();
    }

    public static ArrayList<Bag> getBagListRandomized() {
        ArrayList<Bag> list = new ArrayList<Bag>();
        list.addAll(bagList.values());
        Collections.shuffle(list, LootBags.getRandom());
        return list;
    }

    public static boolean isBagOpened(ItemStack bag) {
        return bag.func_77978_p() != null && bag.func_77978_p().func_74767_n("generated");
    }

    public static int getBagCount() {
        return bagList.size();
    }

    public static int[] getBagValue(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof LootbagItem)) {
            return new int[]{-1, -1};
        }
        return BagHandler.getBag(stack.func_77960_j()).getBagValue();
    }

    public static int[] getBagValue(int ID) {
        return BagHandler.getBag(ID).getBagValue();
    }

    public static boolean isBagInsertable(int ID) {
        return storableinputIDs.contains(ID);
    }

    public static boolean isBagExtractable(int ID) {
        return storableoutputIDs.contains(ID);
    }

    public static ArrayList<Integer> getExtractedBagList() {
        return storableoutputIDs;
    }
}

