/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.tubes.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRegistrator;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityPressureTube
extends TileEntityPneumaticBase
implements IAirListener,
IManoMeasurable,
ICamouflageableTE {
    @DescSynced
    public final boolean[] sidesConnected = new boolean[6];
    @DescSynced
    public final boolean[] sidesClosed = new boolean[6];
    public TubeModule[] modules = new TubeModule[6];
    @DescSynced
    private ItemStack camoStack = ItemStack.field_190927_a;
    private IBlockState camoState;
    private AxisAlignedBB renderBoundingBox = null;

    public TileEntityPressureTube() {
        super(5.0f, 7.0f, 1000, 0);
    }

    public TileEntityPressureTube(float dangerPressurePressureTube, float maxPressurePressureTube, int volumePressureTube) {
        super(dangerPressurePressureTube, maxPressurePressureTube, volumePressureTube, 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("sidesConnected")) {
            byte connected = nbt.func_74771_c("sidesConnected");
            byte closed = nbt.func_74771_c("sidesClosed");
            for (int i = 0; i < 6; ++i) {
                this.sidesConnected[i] = (connected & 1 << i) != 0;
                this.sidesClosed[i] = (closed & 1 << i) != 0;
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.sidesConnected[i] = nbt.func_74767_n("sideConnected" + i);
                this.sidesClosed[i] = nbt.func_74767_n("sideClosed" + i);
            }
        }
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(nbt);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        byte connected = 0;
        byte closed = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.sidesConnected[i]) {
                connected = (byte)(connected | 1 << i);
            }
            if (!this.sidesClosed[i]) continue;
            closed = (byte)(closed | 1 << i);
        }
        nbt.func_74774_a("sidesConnected", connected);
        nbt.func_74774_a("sidesClosed", closed);
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, nbt);
        return nbt;
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        this.writeModulesToNBT(tag);
    }

    public void writeModulesToNBT(NBTTagCompound tag) {
        NBTTagList moduleList = new NBTTagList();
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null) continue;
            NBTTagCompound moduleTag = new NBTTagCompound();
            moduleTag.func_74778_a("type", this.modules[i].getType());
            this.modules[i].writeToNBT(moduleTag);
            moduleTag.func_74768_a("side", i);
            moduleList.func_74742_a((NBTBase)moduleTag);
        }
        tag.func_74782_a("modules", (NBTBase)moduleList);
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.modules = new TubeModule[6];
        NBTTagList moduleList = tag.func_150295_c("modules", 10);
        for (int i = 0; i < moduleList.func_74745_c(); ++i) {
            NBTTagCompound moduleTag = moduleList.func_150305_b(i);
            TubeModule module = ModuleRegistrator.getModule(moduleTag.func_74779_i("type"));
            if (module == null) continue;
            module.readFromNBT(moduleTag);
            this.setModule(module, EnumFacing.func_82600_a((int)moduleTag.func_74762_e("side")));
        }
        this.updateRenderBoundingBox();
        if (this.func_145830_o() && this.func_145831_w().field_72995_K) {
            this.rerenderTileEntity();
        }
    }

    private void updateRenderBoundingBox() {
        this.renderBoundingBox = new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
        for (int i = 0; i < 6; ++i) {
            if (this.modules[i] == null || this.modules[i].getRenderBoundingBox() == null) continue;
            this.renderBoundingBox = this.renderBoundingBox.func_111270_a(this.modules[i].getRenderBoundingBox());
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean hasModules = false;
        for (TubeModule module : this.modules) {
            if (module == null) continue;
            hasModules = true;
            module.shouldDrop = true;
            module.update();
        }
        List<Pair<EnumFacing, IAirHandler>> teList = this.getAirHandler(null).getConnectedPneumatics();
        if (!hasModules && teList.size() == 1 && !this.func_145831_w().field_72995_K) {
            for (Pair<EnumFacing, IAirHandler> entry : teList) {
                if (entry.getKey() == null || this.modules[((EnumFacing)entry.getKey()).func_176734_d().ordinal()] != null || !this.isConnectedTo(((EnumFacing)entry.getKey()).func_176734_d())) continue;
                this.getAirHandler(null).airLeak(((EnumFacing)entry.getKey()).func_176734_d());
            }
        }
    }

    @Override
    public void onAirDispersion(IAirHandler handler, EnumFacing side, int amount) {
        int intSide;
        if (side != null && this.modules[intSide = side.ordinal()] instanceof IInfluenceDispersing) {
            ((IInfluenceDispersing)((Object)this.modules[intSide])).onAirDispersion(amount);
        }
    }

    @Override
    public int getMaxDispersion(IAirHandler handler, EnumFacing side) {
        int intSide;
        if (side != null && this.modules[intSide = side.ordinal()] instanceof IInfluenceDispersing) {
            return ((IInfluenceDispersing)((Object)this.modules[intSide])).getMaxDispersion();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void addConnectedPneumatics(List<Pair<EnumFacing, IAirHandler>> pneumatics) {
    }

    public void setModule(TubeModule module, EnumFacing side) {
        if (module != null) {
            module.setDirection(side);
            module.setTube(this);
        }
        this.modules[side.ordinal()] = module;
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.sendDescriptionPacket();
        }
        this.func_70296_d();
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return !this.sidesClosed[side.ordinal()] && (this.modules[side.ordinal()] == null || this.modules[side.ordinal()].isInline());
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.updateConnections();
        for (TubeModule module : this.modules) {
            if (module == null) continue;
            module.onNeighborTileUpdate();
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.updateConnections();
        for (TubeModule module : this.modules) {
            if (module == null) continue;
            module.onNeighborBlockUpdate();
        }
    }

    private void updateConnections() {
        List<Pair<EnumFacing, IAirHandler>> connections = this.getAirHandler(null).getConnectedPneumatics();
        Arrays.fill(this.sidesConnected, false);
        for (Pair<EnumFacing, IAirHandler> entry : connections) {
            this.sidesConnected[((EnumFacing)entry.getKey()).ordinal()] = true;
        }
        boolean hasModule = false;
        for (int i = 0; i < 6; ++i) {
            if (this.modules[i] == null) continue;
            hasModule = true;
            break;
        }
        int sidesCount = 0;
        for (boolean bool : this.sidesConnected) {
            if (!bool) continue;
            ++sidesCount;
        }
        if (sidesCount == 1 && !hasModule) {
            for (int i = 0; i < 6; ++i) {
                if (!this.sidesConnected[i]) continue;
                EnumFacing opposite = EnumFacing.func_82600_a((int)i).func_176734_d();
                if (!this.isConnectedTo(opposite)) break;
                this.sidesConnected[opposite.ordinal()] = true;
                break;
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (this.modules[i] == null || !this.modules[i].isInline()) continue;
            this.sidesConnected[i] = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoundingBox != null ? this.renderBoundingBox : new AxisAlignedBB(this.func_174877_v());
    }

    @Override
    public void printManometerMessage(EntityPlayer player, List<String> text) {
        EnumFacing dir;
        RayTraceResult mop = PneumaticCraftUtils.getEntityLookedObject((EntityLivingBase)player);
        if (mop != null && mop.hitInfo instanceof EnumFacing && this.modules[(dir = (EnumFacing)mop.hitInfo).ordinal()] != null) {
            this.modules[dir.ordinal()].addInfo(text);
        }
    }

    @Override
    public IBlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(IBlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        this.sendDescriptionPacket();
        this.func_70296_d();
    }

    @Override
    public void onDescUpdate() {
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        super.onDescUpdate();
    }

    public static TileEntityPressureTube getTube(TileEntity te) {
        return te instanceof TileEntityPressureTube ? (TileEntityPressureTube)te : null;
    }
}

