/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.tileentity.TileEntityCompressedIronBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHeatSink
extends TileEntityCompressedIronBlock
implements IHeatExchanger {
    private final IHeatExchangerLogic airExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    private double ambientTemp = -1.0;

    public TileEntityHeatSink() {
        this.airExchanger.addConnectedExchanger(this.heatExchanger);
        this.airExchanger.setThermalResistance(14.0);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return side == null || side == this.getRotation() ? super.getHeatExchangerLogic(side) : null;
    }

    @Override
    protected EnumFacing[] getConnectedHeatExchangerSides() {
        return new EnumFacing[]{this.getRotation()};
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void func_73660_a() {
        if (this.ambientTemp < 0.0) {
            this.ambientTemp = HeatExchangerLogicAmbient.atPosition(this.func_145831_w(), this.func_174877_v()).getTemperature();
            this.airExchanger.setTemperature(this.ambientTemp);
        }
        super.func_73660_a();
        this.airExchanger.update();
        this.airExchanger.setTemperature(this.ambientTemp);
    }

    public void onFannedByAirGrate() {
        this.heatExchanger.update();
        this.airExchanger.setTemperature(this.ambientTemp);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }
}

