/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.util.OreDictionaryHelper;
import net.minecraft.item.ItemStack;

public class ExplosionCraftingRecipe {
    public static final List<ExplosionCraftingRecipe> recipes = new ArrayList<ExplosionCraftingRecipe>();
    private final ItemStack input;
    private final String oreDictKey;
    private final ItemStack output;
    private final int lossRate;

    public static void addExplosionRecipe(ItemStack input, ItemStack output, int lossRate) {
        PneumaticRegistry.getInstance().getRecipeRegistry().registerExplosionCraftingRecipe(input, output, lossRate);
    }

    public static void addExplosionRecipe(String oreDictKey, ItemStack output, int lossRate) {
        PneumaticRegistry.getInstance().getRecipeRegistry().registerExplosionCraftingRecipe(oreDictKey, output, lossRate);
    }

    public ExplosionCraftingRecipe(ItemStack input, ItemStack output, int lossRate) {
        this.input = input;
        this.output = output;
        this.lossRate = lossRate;
        this.oreDictKey = null;
    }

    public ExplosionCraftingRecipe(String oreDictKey, ItemStack output, int lossRate) {
        this.input = ItemStack.field_190927_a;
        this.output = output;
        this.lossRate = lossRate;
        this.oreDictKey = oreDictKey;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public String getOreDictKey() {
        return this.oreDictKey;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getLossRate() {
        return this.lossRate;
    }

    public static ItemStack tryToCraft(ItemStack stack) {
        for (ExplosionCraftingRecipe recipe : recipes) {
            if (!recipe.match(stack)) continue;
            return recipe.createOutput(stack);
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack createOutput(ItemStack stack) {
        Random rand = new Random();
        if (stack.func_190916_E() >= 3 || rand.nextDouble() >= (double)this.lossRate / 100.0) {
            ItemStack newStack = new ItemStack(this.output.func_77973_b(), stack.func_190916_E(), this.output.func_77952_i());
            if (stack.func_190916_E() >= 3) {
                newStack.func_190920_e((int)((double)stack.func_190916_E() * (rand.nextDouble() * Math.min((double)this.lossRate * 0.02, 0.2) + (Math.max(0.9, 1.0 - (double)this.lossRate * 0.01) - (double)this.lossRate * 0.01))));
            }
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean match(ItemStack ingredient) {
        return !this.input.func_190926_b() && ItemStack.func_179545_c((ItemStack)this.input, (ItemStack)ingredient) || this.oreDictKey != null && OreDictionaryHelper.isItemEqual(this.oreDictKey, ingredient);
    }
}

