/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetGoto;
import me.desht.pneumaticcraft.common.ai.DroneEntityAIGoToLocation;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IGotoWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetGoToLocation
extends ProgWidget
implements IGotoWidget,
IAreaProvider {
    public boolean doneWhenDeparting;

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add("gui.progWidget.area.error.noArea");
        }
    }

    @Override
    public boolean doneWhenDeparting() {
        return this.doneWhenDeparting;
    }

    @Override
    public void setDoneWhenDeparting(boolean bool) {
        this.doneWhenDeparting = bool;
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add("Done when " + (this.doneWhenDeparting ? "departing" : "arrived"));
    }

    @Override
    public String getWidgetString() {
        return "goto";
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_GOTO;
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneEntityAIGoToLocation(drone, (ProgWidget)widget);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return null;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class};
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        ProgWidgetAreaItemBase.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[this.getParameters().length]);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("doneWhenDeparting", this.doneWhenDeparting);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.doneWhenDeparting = tag.func_74767_n("doneWhenDeparting");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetGoto(this, guiProgrammer);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public int getCraftingColorIndex() {
        return 12;
    }
}

