/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetDropItem;
import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IItemDropper;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetDropItem
extends ProgWidgetInventoryBase
implements IItemDropper {
    private boolean dropStraight;

    @Override
    public String getWidgetString() {
        return "dropItem";
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_DROP_ITEM;
    }

    @Override
    public boolean dropStraight() {
        return this.dropStraight;
    }

    @Override
    public void setDropStraight(boolean dropStraight) {
        this.dropStraight = dropStraight;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("dropStraight", this.dropStraight);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.dropStraight = tag.func_74767_n("dropStraight");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetDropItem(this, guiProgrammer);
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIImExBase(drone, (ProgWidgetAreaItemBase)widget){
            private final Set<BlockPos> visitedPositions;
            {
                this.visitedPositions = new HashSet<BlockPos>();
            }

            @Override
            public boolean func_75250_a() {
                boolean shouldExecute = false;
                for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                    ItemStack stack = this.drone.getInv().getStackInSlot(i);
                    if (!this.widget.isItemValidForFilters(stack)) continue;
                    shouldExecute = super.func_75250_a();
                    break;
                }
                return shouldExecute;
            }

            @Override
            protected boolean moveIntoBlock() {
                return true;
            }

            @Override
            protected boolean isValidPosition(BlockPos pos) {
                return !this.visitedPositions.contains(pos);
            }

            @Override
            protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
                this.visitedPositions.add(pos);
                for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                    ItemStack stack = this.drone.getInv().getStackInSlot(i);
                    if (!this.widget.isItemValidForFilters(stack)) continue;
                    if (this.useCount() && this.getRemainingCount() < stack.func_190916_E()) {
                        stack = stack.func_77979_a(this.getRemainingCount());
                        this.decreaseCount(this.getRemainingCount());
                    } else {
                        this.decreaseCount(stack.func_190916_E());
                        this.drone.getInv().setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    EntityItem item = new EntityItem(this.drone.world(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                    if (((IItemDropper)((Object)this.widget)).dropStraight()) {
                        item.field_70159_w = 0.0;
                        item.field_70181_x = 0.0;
                        item.field_70179_y = 0.0;
                    }
                    this.drone.world().func_72838_d((Entity)item);
                    if (this.useCount() && this.getRemainingCount() == 0) break;
                }
                return false;
            }
        };
    }

    @Override
    public int getCraftingColorIndex() {
        return 9;
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public String getExtraStringInfo() {
        return this.dropStraight() ? "Straight" : "Random";
    }
}

