/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.commons.lang3.Validate;

public class PacketAmadronInvSync
extends AbstractPacket<PacketAmadronInvSync> {
    private static final int INV_SIZE = 16;
    private final List<ItemStack> items = new ArrayList<ItemStack>(16);

    public PacketAmadronInvSync() {
    }

    public PacketAmadronInvSync(List<ItemStack> items) {
        Validate.isTrue((items.size() == 16 ? 1 : 0) != 0, (String)("invalid list size: expected 16, got " + items.size()), (Object[])new Object[0]);
        this.items.addAll(items);
    }

    public void fromBytes(ByteBuf buf) {
        for (int i = 0; i < 16; ++i) {
            this.items.add(ByteBufUtils.readItemStack((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        for (ItemStack stack : this.items) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }

    @Override
    public void handleClientSide(PacketAmadronInvSync message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketAmadronInvSync message, EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerAmadron) {
            ContainerAmadron container = (ContainerAmadron)player.field_71070_bA;
            for (int i = 0; i < this.items.size(); ++i) {
                container.setStack(i, this.items.get(i));
            }
        }
    }
}

