/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.List;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IPneumaticMachine;
import me.desht.pneumaticcraft.client.ClientTickHandler;
import me.desht.pneumaticcraft.client.model.module.ModelModuleBase;
import me.desht.pneumaticcraft.client.model.module.ModelPressureRegulator;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.tubes.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.block.tubes.TubeModuleRedstoneReceiving;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ModuleRegulatorTube
extends TubeModuleRedstoneReceiving
implements IInfluenceDispersing {
    public static boolean hasTicked;
    public static boolean inLine;
    public static boolean inverted;

    @SideOnly(value=Side.CLIENT)
    private void renderPreview() {
        if (!hasTicked) {
            TileEntityPneumaticBase tile = (TileEntityPneumaticBase)this.getTube();
            NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(tile.func_174877_v()));
            TileEntity neighbor = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(this.dir));
            inLine = neighbor instanceof IPneumaticMachine;
            if (inLine) {
                IAirHandler neighborHandler = ((IPneumaticMachine)neighbor).getAirHandler(this.dir);
                inverted = neighborHandler != null && neighborHandler.getPressure() > tile.getAirHandler(null).getPressure();
                NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(neighbor.func_174877_v()));
            }
            hasTicked = true;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (inLine && !inverted) {
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)1.0, (double)(0.2 + (double)(ClientTickHandler.TICKS % 20) * 0.015));
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderUtils.render3DArrow();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
    }

    @Override
    public String getType() {
        return "regulator_tube_module";
    }

    @Override
    public int getMaxDispersion() {
        IAirHandler connectedHandler = null;
        for (Pair<EnumFacing, IAirHandler> entry : this.pressureTube.getAirHandler(null).getConnectedPneumatics()) {
            if (!((EnumFacing)entry.getKey()).equals((Object)this.dir)) continue;
            connectedHandler = (IAirHandler)entry.getValue();
            break;
        }
        if (connectedHandler == null) {
            return 0;
        }
        int maxDispersion = (int)((this.getThreshold() - connectedHandler.getPressure()) * (float)connectedHandler.getVolume());
        if (maxDispersion < 0) {
            return 0;
        }
        return maxDispersion;
    }

    @Override
    public void onAirDispersion(int amount) {
    }

    @Override
    public void addInfo(List<String> curInfo) {
        super.addInfo(curInfo);
        curInfo.add("Threshold: " + TextFormatting.WHITE + PneumaticCraftUtils.roundNumberTo(this.getThreshold(), 1) + " bar");
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public Class<? extends ModelModuleBase> getModelClass() {
        return ModelPressureRegulator.class;
    }
}

