/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.pressure.AirHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.TileEntityCache;
import net.minecraft.world.World;

public class ModuleNetworkManager {
    private static final Map<Integer, ModuleNetworkManager> INSTANCES = new HashMap<Integer, ModuleNetworkManager>();
    private final Map<TubeModule, Set<TubeModule>> connectionCache = new HashMap<TubeModule, Set<TubeModule>>();
    private boolean needInvalidate = false;

    public static ModuleNetworkManager getInstance(World w) {
        return INSTANCES.computeIfAbsent(w.field_73011_w.getDimension(), dimId -> new ModuleNetworkManager());
    }

    Set<TubeModule> getConnectedModules(TubeModule module) {
        if (this.needInvalidate) {
            this.connectionCache.clear();
            this.needInvalidate = false;
        }
        return this.connectionCache.computeIfAbsent(module, this::computeConnections);
    }

    public void invalidateCache() {
        this.needInvalidate = true;
    }

    private Set<TubeModule> computeConnections(TubeModule module) {
        HashSet<TubeModule> modules = new HashSet<TubeModule>();
        HashSet<TileEntityPressureTube> traversedTubes = new HashSet<TileEntityPressureTube>();
        Stack<TileEntityPressureTube> pendingTubes = new Stack<TileEntityPressureTube>();
        pendingTubes.push((TileEntityPressureTube)module.getTube());
        while (!pendingTubes.isEmpty()) {
            TileEntityPressureTube tube = (TileEntityPressureTube)pendingTubes.pop();
            for (TubeModule m : tube.modules) {
                if (!(m instanceof INetworkedModule) || module.getClass() != m.getClass()) continue;
                modules.add(m);
            }
            TileEntityCache[] cache = ((AirHandler)tube.getAirHandler(null)).getTileCache();
            for (int dir = 0; dir < 6; ++dir) {
                TileEntityPressureTube newTube;
                if (!this.isTubeConnected(tube, dir) || (newTube = TileEntityPressureTube.getTube(cache[dir].getTileEntity())) == null || traversedTubes.contains(newTube)) continue;
                pendingTubes.add(newTube);
                traversedTubes.add(newTube);
            }
        }
        return modules;
    }

    private boolean isTubeConnected(TileEntityPressureTube tube, int dir) {
        return !tube.sidesClosed[dir] && (tube.sidesConnected[dir] || tube.modules[dir] != null && tube.modules[dir].isInline());
    }
}

