/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftModeled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPlasticMixer;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPlasticMixer
extends BlockPneumaticCraftModeled {
    private static final AxisAlignedBB BLOCK_BOUNDS = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    private static final AxisAlignedBB COLLISION_BOUNDS = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    BlockPlasticMixer() {
        super(Material.field_151573_f, "plastic_mixer");
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityPlasticMixer.class;
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return GuiHandler.EnumGuiId.PLASTIC_MIXER;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_BOUNDS;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_BOUNDS;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (drops.isEmpty()) {
            return;
        }
        ItemStack teStack = (ItemStack)drops.get(0);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPlasticMixer) {
            int[] buffers = ((TileEntityPlasticMixer)te).dyeBuffers;
            for (int i = 0; i < 3; ++i) {
                NBTUtil.setInteger(teStack, "dyeBuffer" + i, buffers[i]);
            }
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPlasticMixer && stack.func_77942_o()) {
            int[] buffers = ((TileEntityPlasticMixer)te).dyeBuffers;
            for (int i = 0; i < 3; ++i) {
                buffers[i] = NBTUtil.getInteger(stack, "dyeBuffer" + i);
            }
        }
    }
}

