/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.DroneAIDig;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetPlace;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DroneAIBlockInteract
extends DroneAIBlockInteraction {
    private final List<BlockPos> visitedPositions = new ArrayList<BlockPos>();

    public DroneAIBlockInteract(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
        drone.getFakePlayer().func_70095_a(((IBlockRightClicker)((Object)widget)).isSneaking());
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return !this.visitedPositions.contains(pos) && (this.widget.isItemFilterEmpty() || DroneAIDig.isBlockValidForFilter((IBlockAccess)this.drone.world(), this.drone, pos, this.widget));
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        this.visitedPositions.add(pos);
        boolean result = this.rightClick(pos);
        if (this.drone.getFakePlayer().func_184614_ca().func_190916_E() <= 0) {
            this.drone.getFakePlayer().func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        return result;
    }

    private boolean rightClick(BlockPos pos) {
        EnumFacing faceDir = ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides());
        EntityPlayerMP player = this.drone.getFakePlayer();
        World world = this.drone.world();
        ItemStack stack = player.func_184614_ca();
        player.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5 - (double)player.eyeHeight, (double)pos.func_177952_p() + 0.5);
        player.field_70125_A = faceDir.func_96559_d() * -90;
        player.field_70177_z = PneumaticCraftUtils.getYawFromFacing(faceDir);
        float hitX = (float)(player.field_70165_t - (double)pos.func_177958_n());
        float hitY = (float)(player.field_70163_u - (double)pos.func_177956_o());
        float hitZ = (float)(player.field_70161_v - (double)pos.func_177952_p());
        try {
            Block block;
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND, (BlockPos)pos, (EnumFacing)faceDir.func_176734_d(), (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)player, (double)2.0));
            if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
                return false;
            }
            EnumActionResult ret = stack.onItemUseFirst((EntityPlayer)player, world, pos, EnumHand.MAIN_HAND, faceDir, hitX, hitY, hitZ);
            if (ret != EnumActionResult.PASS) {
                return false;
            }
            boolean bypass = player.func_184614_ca().doesSneakBypassUse((IBlockAccess)world, pos, (EntityPlayer)player);
            EnumActionResult result = EnumActionResult.PASS;
            if (!player.func_70093_af() || bypass || event.getUseBlock() == Event.Result.ALLOW) {
                IBlockState iblockstate = world.func_180495_p(pos);
                if (event.getUseBlock() != Event.Result.DENY && iblockstate.func_177230_c().func_180639_a(world, pos, iblockstate, (EntityPlayer)player, EnumHand.MAIN_HAND, faceDir, hitX, hitY, hitZ)) {
                    result = EnumActionResult.SUCCESS;
                }
            }
            if (stack.func_190926_b() || player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                return false;
            }
            if (stack.func_77973_b() instanceof ItemBlock && !player.func_189808_dh() && ((block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof BlockCommandBlock || block instanceof BlockStructure)) {
                return false;
            }
            if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
                ItemStack copyBeforeUse = stack.func_77946_l();
                result = stack.func_179546_a((EntityPlayer)player, world, pos, EnumHand.MAIN_HAND, faceDir, hitX, hitY, hitZ);
                if (result == EnumActionResult.PASS) {
                    ActionResult rightClickResult = stack.func_77973_b().func_77659_a(world, (EntityPlayer)player, EnumHand.MAIN_HAND);
                    player.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)rightClickResult.func_188398_b());
                }
                if (player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)EnumHand.MAIN_HAND);
                }
            }
            return false;
        }
        catch (Throwable e) {
            Log.error("DroneAIBlockInteract crashed! Stacktrace: ");
            e.printStackTrace();
            return false;
        }
    }
}

