/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.semiblock;

import me.desht.pneumaticcraft.client.model.semiblocks.ModelHeatFrame;
import me.desht.pneumaticcraft.client.semiblock.ISemiBlockRenderer;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockHeatFrame;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class SemiBlockRendererHeatFrame
implements ISemiBlockRenderer<SemiBlockHeatFrame> {
    private final ModelHeatFrame model = new ModelHeatFrame();
    private static final AxisAlignedBB DEFAULT_BOX = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);

    @Override
    public void render(SemiBlockHeatFrame semiBlock, float partialTick) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Textures.MODEL_HEAT_FRAME);
        GlStateManager.func_179098_w();
        int heatLevel = semiBlock.getHeatLevel();
        float[] color = HeatUtil.getColorForHeatLevel(heatLevel);
        float lightMul = this.getLightMultiplier(semiBlock);
        GlStateManager.func_179131_c((float)(color[0] * lightMul), (float)(color[1] * lightMul), (float)(color[2] * lightMul), (float)1.0f);
        AxisAlignedBB aabb = semiBlock.getWorld() != null ? semiBlock.getBlockState().func_185900_c((IBlockAccess)semiBlock.getWorld(), semiBlock.getPos()) : DEFAULT_BOX;
        GlStateManager.func_179137_b((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c);
        GlStateManager.func_179139_a((double)(aabb.field_72336_d - aabb.field_72340_a), (double)(aabb.field_72337_e - aabb.field_72338_b), (double)(aabb.field_72334_f - aabb.field_72339_c));
        GlStateManager.func_179137_b((double)0.5, (double)-0.5, (double)0.5);
        this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private float getLightMultiplier(SemiBlockHeatFrame semiBlock) {
        if (!ConfigHandler.client.semiBlockLighting) {
            return 1.0f;
        }
        float lightMul = Math.max(0.05f, (float)Minecraft.func_71410_x().field_71441_e.func_175699_k(semiBlock.getPos()) / 15.0f);
        if (semiBlock.getHeatLevel() > 15) {
            lightMul = Math.min(6.0f, lightMul + (float)(semiBlock.getHeatLevel() - 15) / 3.0f);
        } else if (semiBlock.getHeatLevel() > 11) {
            lightMul += 0.07f * (float)(semiBlock.getHeatLevel() - 11);
        }
        return lightMul;
    }
}

