/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.utils.wrappers;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Wrapper<T> {
    public T value;
    public Predicate<T> predicate = t -> true;

    public Wrapper(T value) {
        this.value = value;
    }

    public Wrapper<T> push(@Nullable T value) {
        if (value != null && this.predicate.test(value)) {
            this.value = value;
        }
        return this;
    }

    public Wrapper<T> or(Supplier<T> s) {
        if (this.value == null) {
            this.value = s.get();
        }
        return this;
    }

    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }

    public Wrapper<T> ifPresent(Consumer<T> c) {
        if (this.value != null) {
            c.accept(this.value);
        }
        return this;
    }

    public Wrapper<T> ifPresentNot(Runnable r) {
        if (this.value == null) {
            r.run();
        }
        return this;
    }
}

