/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WLabel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class WLabelGroup
extends WContainer {
    ArrayList<WLabel> labels = new ArrayList();
    IWidget.ListenerValue<? super WLabelGroup, Integer> listener;

    public WLabelGroup(int xPos, int yPos, int column, int row, WLabel.Mode mode) {
        this(xPos, yPos, column, row, 18, 18, mode);
    }

    public WLabelGroup(int xPos, int yPos, int column, int row, int xSize, int ySize, WLabel.Mode mode) {
        IntStream.range(0, row).forEach(r -> IntStream.range(0, column).forEach(c -> {
            WLabel l = new WLabel(xPos + c * xSize, yPos + r * ySize, xSize, ySize, mode).setListener((? super WLabel i, ILabel v) -> {
                if (this.listener != null) {
                    this.listener.invoke(this, r * column + c);
                }
            });
            this.labels.add(l);
            this.add((IWidget)l);
        }));
    }

    public ILabel get(int index) {
        return this.labels.get(index).getLabel();
    }

    public List<ILabel> getLabels() {
        return this.labels.stream().map(WLabel::getLabel).collect(Collectors.toList());
    }

    public void setLabel(ILabel label, int index) {
        this.labels.get(index).setLabel(label);
    }

    public void setLabel(List<ILabel> labels, int start) {
        for (WLabel label : this.labels) {
            label.setLabel(start < labels.size() ? labels.get(start++) : ILabel.EMPTY);
        }
    }

    public WLabelGroup setListener(IWidget.ListenerValue<? super WLabelGroup, Integer> listener) {
        this.listener = listener;
        return this;
    }
}

