/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WSwitcher;
import me.towdium.jecalculation.gui.widgets.WText;
import me.towdium.jecalculation.gui.widgets.WTooltip;
import me.towdium.jecalculation.utils.Utilities;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WHelp
extends WContainer {
    protected String key;

    public WHelp(String content) {
        this.key = content;
        if (((Boolean)Utilities.I18n.search((String)new StringBuilder().append((String)"gui.").append((String)this.key).append((String)".title").toString(), (Object[])new Object[0]).two).booleanValue() && ((Boolean)Utilities.I18n.search((String)new StringBuilder().append((String)"gui.").append((String)this.key).append((String)".help").toString(), (Object[])new Object[0]).two).booleanValue()) {
            this.add((IWidget)new Impl());
        }
    }

    private class Doc
    extends WContainer {
        Text text = new Text();
        WSwitcher switcher = new WSwitcher(7, 146, 162, this.text.amount()).setListener(i -> this.text.setPage(i.getIndex()));

        public Doc() {
            WText title = new WText(7, 7, JecaGui.Font.SHADOW, Utilities.I18n.get("gui." + WHelp.this.key + ".title", new Object[0]));
            this.add(new WPanel(), new Icon(), title, this.text, this.switcher);
        }

        @Override
        public boolean onClicked(JecaGui gui, int xMouse, int yMouse, int button) {
            if (!super.onClicked(gui, xMouse, yMouse, button)) {
                gui.root.remove(this);
            }
            return true;
        }

        @Override
        public boolean onScroll(JecaGui gui, int xMouse, int yMouse, int diff) {
            this.switcher.move(-diff);
            this.text.setPage(this.switcher.getIndex());
            return super.onScroll(gui, xMouse, yMouse, diff);
        }

        public class Icon
        extends WTooltip {
            public Icon() {
                super("common.close");
            }

            @Override
            public void onDraw(JecaGui gui, int xMouse, int yMouse) {
                super.onDraw(gui, xMouse, yMouse);
                gui.drawResourceContinuous(Resource.WGT_HELP_B, -21, 0, 25, 24, 4);
                gui.drawResource(Resource.WGT_HELP_F, -19, 2);
            }

            @Override
            public boolean onTooltip(JecaGui gui, int xMouse, int yMouse, List<String> tooltip) {
                super.onTooltip(gui, xMouse, yMouse, tooltip);
                return this.mouseIn(xMouse, yMouse);
            }

            @Override
            public boolean onClicked(JecaGui gui, int xMouse, int yMouse, int button) {
                boolean ret = this.mouseIn(xMouse, yMouse);
                if (ret) {
                    gui.root.remove(Doc.this);
                }
                return ret;
            }

            @Override
            public boolean mouseIn(int xMouse, int yMouse) {
                return JecaGui.mouseIn(-21, 0, 24, 24, xMouse, yMouse);
            }

            @Override
            public boolean onKey(JecaGui gui, char ch, int code) {
                if (super.onKey(gui, ch, code)) {
                    return true;
                }
                if (code == 1) {
                    gui.root.remove(Doc.this);
                    return true;
                }
                return false;
            }
        }

        public class Text
        implements IWidget {
            List<List<String>> pages = new ArrayList<List<String>>();
            int page;

            public Text() {
                List<String> ss = Utilities.I18n.wrap(Utilities.I18n.get("gui." + WHelp.this.key + ".help", new Object[0]), 162);
                ArrayList<String> tmp = new ArrayList<String>();
                int count = 0;
                for (String s : ss) {
                    if (s.endsWith("\f")) {
                        tmp.add(s.substring(0, s.length() - 1));
                        this.pages.add(tmp);
                        tmp = new ArrayList();
                        count = 0;
                        continue;
                    }
                    if (count == 11) {
                        tmp.add(s);
                        this.pages.add(tmp);
                        tmp = new ArrayList();
                        count = 0;
                        continue;
                    }
                    tmp.add(s);
                    ++count;
                }
                if (!tmp.isEmpty()) {
                    this.pages.add(tmp);
                }
            }

            @Override
            public void onDraw(JecaGui gui, int xMouse, int yMouse) {
                gui.drawSplitText(7.0f, 21.0f, JecaGui.Font.PLAIN, this.pages.get(this.page));
            }

            public int amount() {
                return this.pages.size();
            }

            public void setPage(int i) {
                this.page = i;
            }
        }
    }

    private class Impl
    extends WTooltip {
        public Impl() {
            super("common.help");
        }

        @Override
        public void onDraw(JecaGui gui, int xMouse, int yMouse) {
            super.onDraw(gui, xMouse, yMouse);
            gui.drawResourceContinuous(Resource.WGT_PANEL_N, -21, 0, 25, 24, 4);
            gui.drawResource(Resource.WGT_HELP_N, -19, 2);
        }

        @Override
        public boolean mouseIn(int xMouse, int yMouse) {
            return JecaGui.mouseIn(-21, 0, 24, 24, xMouse, yMouse);
        }

        @Override
        public boolean onClicked(JecaGui gui, int xMouse, int yMouse, int button) {
            boolean ret = this.mouseIn(xMouse, yMouse);
            if (ret) {
                gui.root.add(new Doc());
            }
            return ret;
        }
    }
}

