/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.structure.Recipes;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.gui.widgets.ISearchable;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WHelp;
import me.towdium.jecalculation.gui.widgets.WIcon;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WSearch;
import me.towdium.jecalculation.gui.widgets.WSwitcher;
import me.towdium.jecalculation.gui.widgets.WText;
import me.towdium.jecalculation.gui.widgets.WTick;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import me.towdium.jecalculation.utils.wrappers.Quad;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GuiImport
extends WContainer
implements IGui,
ISearchable {
    List<Quad<Boolean, String, String, Recipes>> data;
    List<Quad<Boolean, String, String, Recipes>> filtered;
    WSearch search = new WSearch(26, 25, 90, this);
    WSwitcher page;
    WButton confirm = new WButtonIcon(149, 25, 20, 20, Resource.BTN_YES, "import.confirm").setDisabled(true).setListener(i -> {
        this.data.stream().filter(j -> (Boolean)j.one).forEach(j -> Controller.inport((Recipes)j.four, (String)j.three));
        JecaGui.displayParent();
    });
    List<Pair<WTick, WText>> content = new ArrayList<Pair<WTick, WText>>();

    public GuiImport() {
        this.add(new WHelp("import"), new WPanel());
        this.add((IWidget)new WIcon(7, 25, 20, 20, Resource.ICN_TEXT, "common.search"));
        this.add(this.search, this.confirm);
        IntStream.range(0, 7).forEach(i -> {
            WTick tick = new WTick(7, 49 + 16 * i, 13, 13, "import.tick").setDisabled(true).setListener(j -> {
                this.filtered.get((int)(this.page.getIndex() * 7 + i)).one = j.selected();
                this.confirm.setDisabled(this.data.stream().noneMatch(k -> (Boolean)k.one));
            });
            WTextExpand text = new WTextExpand(49 + 16 * i, "");
            this.add(tick, text);
            this.content.add(new Pair<WTick, WTextExpand>(tick, text));
        });
    }

    @Override
    public void onVisible(JecaGui gui) {
        this.data = Controller.discover().stream().flatMap(i -> ((Recipes)i.two).stream().map(j -> new Quad(false, i.one, j.one, i.two))).collect(Collectors.toList());
        this.search.refresh();
    }

    public void refresh() {
        for (int i = 0; i < this.content.size(); ++i) {
            Pair<WTick, WText> pair = this.content.get(i);
            int index = i + 7 * this.page.getIndex();
            if (index >= this.filtered.size()) {
                ((WTick)pair.one).setSelected(false).setDisabled(true);
                ((WText)pair.two).key = "";
                continue;
            }
            Quad<Boolean, String, String, Recipes> quad = this.filtered.get(index);
            ((WTick)pair.one).setSelected((Boolean)quad.one).setDisabled(false);
            ((WText)pair.two).key = (String)quad.two + " -> " + (String)quad.three;
        }
    }

    @Override
    public boolean setFilter(String s) {
        this.filtered = s.isEmpty() ? new ArrayList<Quad<Boolean, String, String, Recipes>>(this.data) : this.data.stream().filter(i -> Utilities.I18n.contains((String)i.two, s) || Utilities.I18n.contains((String)i.three, s)).collect(Collectors.toList());
        this.remove(this.page);
        this.page = new WSwitcher(7, 7, 162, (this.filtered.size() + 6) / 7).setListener(i -> this.refresh());
        this.add((IWidget)this.page);
        this.refresh();
        return !this.filtered.isEmpty();
    }

    private static class WTextExpand
    extends WText {
        boolean expand = false;

        public WTextExpand(int yPos, String key) {
            super(25, yPos + 2, 140, JecaGui.Font.SHADOW, key, false);
        }

        @Override
        public void onDraw(JecaGui gui, int xMouse, int yMouse) {
            gui.drawRectangle(22, this.yPos - 2, 146, 13, -6184543);
            super.onDraw(gui, xMouse, yMouse);
            if (this.expand) {
                if (JecaGui.mouseIn(22, this.yPos - 2, gui.getStringWidth(this.key) + 6, 13, xMouse, yMouse)) {
                    gui.drawRectangle(22, this.yPos - 2, gui.getStringWidth(this.key) + 6, 13, -6184543);
                    gui.drawText(25.0f, (float)this.yPos, JecaGui.Font.SHADOW, this.key);
                } else {
                    this.expand = false;
                }
            } else if (JecaGui.mouseIn(22, this.yPos - 2, 146, 13, xMouse, yMouse) && gui.getStringWidth(this.key) > 140) {
                gui.drawRectangle(22, this.yPos - 2, gui.getStringWidth(this.key) + 6, 13, -6184543);
                gui.drawText(25.0f, (float)this.yPos, JecaGui.Font.SHADOW, this.key);
                this.expand = true;
            }
        }

        @Override
        public boolean onTooltip(JecaGui gui, int xMouse, int yMouse, List<String> tooltip) {
            return JecaGui.mouseIn(22, this.yPos - 2, this.expand ? gui.getStringWidth(this.key) + 6 : 146, 13, xMouse, yMouse);
        }
    }
}

