/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class StackHelper {
    public static final String BLOCK_ENTITY_TAG = "BlockEntityTag";

    public static boolean isFuel(ItemStack itemStack) {
        return TileEntityFurnace.func_145954_b((ItemStack)itemStack);
    }

    public static int getItemBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemStack);
    }

    public static ItemStack decreaseStackInSlot(ItemStackHandler stackHandler, int slot, int amount, boolean checkContainer) {
        ItemStack stackInSlot = stackHandler.getStackInSlot(slot).func_77946_l();
        ItemStack adjustedStack = StackHelper.decrease(stackInSlot, amount, checkContainer);
        stackHandler.setStackInSlot(slot, adjustedStack);
        return adjustedStack;
    }

    @Nonnull
    public static NBTTagCompound getTagSafe(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return new NBTTagCompound();
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        return tag;
    }

    @ParametersAreNonnullByDefault
    public static List<ItemStack> copyInto(List<ItemStack> sourceList, List<ItemStack> targetList) {
        for (ItemStack itemStack : sourceList) {
            targetList.add(itemStack.func_77946_l());
        }
        return targetList;
    }

    public static ItemStack decrease(ItemStack itemStack, int amount, boolean checkContainer) {
        if (itemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        itemStack.func_190918_g(amount);
        if (itemStack.func_190916_E() <= 0) {
            if (checkContainer && itemStack.func_77973_b().hasContainerItem(itemStack)) {
                return itemStack.func_77973_b().getContainerItem(itemStack);
            }
            return ItemStack.field_190927_a;
        }
        return itemStack;
    }

    public static void addToInventoryOrSpawn(World world, EntityPlayer player, ItemStack itemStack, BlockPos pos, double offsetY, boolean preferActiveSlot, boolean playPickupSound) {
        if (preferActiveSlot) {
            PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
            ItemStack remainder = inventory.insertItem(player.field_71071_by.field_70461_c, itemStack, false);
            if (!remainder.func_190926_b()) {
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)remainder, (boolean)false);
            }
            if (playPickupSound && remainder.func_190926_b() || remainder.func_190916_E() != itemStack.func_190916_E()) {
                world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            if (!remainder.func_190926_b() && !world.field_72995_K) {
                StackHelper.spawnStackOnTop(world, itemStack, pos, offsetY);
            }
        } else if (!player.field_71071_by.func_70441_a(itemStack)) {
            if (!world.field_72995_K) {
                StackHelper.spawnStackOnTop(world, itemStack, pos, offsetY);
            }
        } else if (playPickupSound) {
            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public static void spawnStackHandlerContentsOnTop(World world, ItemStackHandler stackHandler, BlockPos pos) {
        StackHelper.spawnStackHandlerContentsOnTop(world, stackHandler, pos, 1.0);
    }

    public static void spawnStackHandlerContentsOnTop(World world, ItemStackHandler stackHandler, BlockPos pos, double offsetY) {
        for (int slot = 0; slot < stackHandler.getSlots(); ++slot) {
            StackHelper.spawnStackHandlerSlotContentsOnTop(world, stackHandler, slot, pos, offsetY);
        }
    }

    public static void spawnStackHandlerSlotContentsOnTop(World world, ItemStackHandler stackHandler, int slot, BlockPos pos) {
        StackHelper.spawnStackHandlerSlotContentsOnTop(world, stackHandler, slot, pos, 1.0);
    }

    public static void spawnStackHandlerSlotContentsOnTop(World world, ItemStackHandler stackHandler, int slot, BlockPos pos, double offsetY) {
        ItemStack itemStack;
        while (!(itemStack = stackHandler.extractItem(slot, stackHandler.getSlotLimit(slot), false)).func_190926_b()) {
            StackHelper.spawnStackOnTop(world, itemStack, pos, offsetY);
        }
    }

    public static void spawnStackOnTop(World world, ItemStack itemStack, BlockPos pos) {
        StackHelper.spawnStackOnTop(world, itemStack, pos, 1.0);
    }

    public static void spawnStackOnTop(World world, ItemStack itemStack, BlockPos pos, double offsetY) {
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5 + offsetY, (double)pos.func_177952_p() + 0.5, itemStack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.1;
        entityItem.field_70179_y = 0.0;
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack createItemStackFromTileEntity(Block block, int amount, int meta, TileEntity tileEntity) {
        return StackHelper.createItemStackFromTileEntity(Item.func_150898_a((Block)block), amount, meta, tileEntity);
    }

    public static ItemStack createItemStackFromTileEntity(Item item, int amount, int meta, TileEntity tileEntity) {
        ItemStack itemStack = new ItemStack(item, amount, meta);
        return StackHelper.writeTileEntityToItemStack(tileEntity, itemStack);
    }

    public static ItemStack writeTileEntityToItemStack(TileEntity tileEntity, ItemStack itemStack) {
        NBTTagCompound compound = itemStack.func_77978_p() != null ? itemStack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound teCompound = new NBTTagCompound();
        tileEntity.func_189515_b(teCompound);
        compound.func_74782_a(BLOCK_ENTITY_TAG, (NBTBase)teCompound);
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    public static <T extends TileEntity> T readTileEntityFromItemStack(T tile, ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            NBTTagCompound teCompound = tagCompound.func_74775_l(BLOCK_ENTITY_TAG);
            tile.func_145839_a(teCompound);
        }
        return tile;
    }

    public static ItemStack readLargeItemStack(NBTTagCompound compound) {
        ItemStack itemStack = new ItemStack((NBTTagCompound)Preconditions.checkNotNull((Object)compound));
        itemStack.func_190920_e(compound.func_74762_e("CountLarge"));
        return itemStack;
    }

    public static NBTTagCompound writeLargeItemStack(ItemStack itemStack, NBTTagCompound compound) {
        itemStack.func_77955_b(compound);
        compound.func_74768_a("CountLarge", itemStack.func_190916_E());
        return compound;
    }

    private StackHelper() {
    }
}

