/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public final class FluidUtilFix {
    public static boolean interactWithFluidHandler(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull IFluidHandler handler) {
        IItemHandler playerInventory;
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && (playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)handler, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
            if (!fluidActionResult.isSuccess()) {
                fluidActionResult = FluidUtilFix.tryEmptyContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
            }
            if (fluidActionResult.isSuccess()) {
                player.func_184611_a(hand, fluidActionResult.getResult());
                return true;
            }
        }
        return false;
    }

    public static FluidActionResult tryEmptyContainerAndStow(@Nonnull ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable EntityPlayer player, boolean doDrain) {
        if (container.func_190926_b()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.field_71075_bZ.field_75098_d) {
            FluidActionResult emptiedReal = FluidUtilFix.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.func_190916_E() == 1) {
            FluidActionResult emptiedReal = FluidUtilFix.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = FluidUtilFix.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedSimulated.getResult(), (boolean)true)).func_190926_b() || player != null)) {
                FluidActionResult emptiedReal = FluidUtilFix.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedReal.getResult(), (!doDrain ? 1 : 0) != 0);
                if (!remainder.func_190926_b() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.func_77946_l();
                containerCopy.func_190918_g(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable EntityPlayer player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)containerCopy);
        if (containerFluidHandler != null) {
            if (doDrain) {
                FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)true);
                if (transfer != null) {
                    if (player != null) {
                        SoundEvent soundevent = transfer.getFluid().getEmptySound(transfer);
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    ItemStack resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            } else {
                FluidStack drained;
                FluidStack simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)false);
                if (simulatedTransfer != null && (drained = containerFluidHandler.drain(simulatedTransfer, true)) != null) {
                    ItemStack resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            }
        }
        return FluidActionResult.FAILURE;
    }

    private FluidUtilFix() {
    }
}

