/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile.data;

import com.codetaylor.mc.athenaeum.inventory.IObservableEnergyStorage;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataEnergyStorage;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileDataBase;
import com.google.common.base.Preconditions;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class TileDataEnergyStorage<T extends IEnergyStorage & ITileDataEnergyStorage>
extends TileDataBase {
    private T energyStorage;

    public TileDataEnergyStorage(T energyStorage) {
        this(energyStorage, 1);
    }

    public TileDataEnergyStorage(T energyStorage, int updateInterval) {
        super(updateInterval);
        this.energyStorage = energyStorage;
        ((IObservableEnergyStorage)this.energyStorage).addObserver((handler, slot) -> this.setDirty(true));
        this.setDirty(true);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        NBTTagCompound compound = (NBTTagCompound)Preconditions.checkNotNull((Object)buffer.func_150793_b());
        ((INBTSerializable)this.energyStorage).deserializeNBT((NBTBase)compound);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150786_a((NBTTagCompound)((INBTSerializable)this.energyStorage).serializeNBT());
    }
}

