/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class InteractionBase<T extends TileEntity>
implements IInteraction<T> {
    protected final int sides;
    protected final AxisAlignedBB bounds;

    public InteractionBase(EnumFacing[] sides, AxisAlignedBB bounds) {
        this.bounds = bounds;
        int sidesEncoded = 0;
        for (EnumFacing side : sides) {
            sidesEncoded |= 1 << side.func_176745_a();
        }
        this.sides = sidesEncoded;
    }

    @Override
    public AxisAlignedBB getInteractionBounds(World world, BlockPos pos, IBlockState blockState) {
        return this.bounds;
    }

    @Override
    public boolean allowInteractionWithSide(EnumFacing facing) {
        return (this.sides & 1 << facing.func_176745_a()) == 1 << facing.func_176745_a();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderAdditivePassForStackInSlot(boolean sneaking, ItemStack heldItemMainHand) {
        return heldItemMainHand.func_190926_b();
    }
}

