/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.api;

import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionItemStack;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionRenderer;
import com.codetaylor.mc.athenaeum.util.RenderHelper;
import java.awt.Color;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.util.vector.Quaternion;

public final class InteractionRenderers {
    public static final InteractionRenderer_ItemStack ITEM_STACK = new InteractionRenderer_ItemStack();

    public static void renderItemModel(RenderItem renderItem, ItemStack itemStack, Transform transform) {
        GlStateManager.func_179094_E();
        InteractionRenderers.setupItemTransforms(transform);
        IBakedModel model = renderItem.func_184393_a(itemStack, null, null);
        RenderHelper.renderItemModel(itemStack, model, ItemCameraTransforms.TransformType.NONE, false, false);
        GlStateManager.func_179121_F();
    }

    public static void renderItemCount(FontRenderer fontRenderer, int yaw, ItemStack itemStack, Transform transform, Vec3d offset) {
        GlStateManager.func_179094_E();
        if (transform != Transform.IDENTITY) {
            GlStateManager.func_179137_b((double)transform.translation.field_72450_a, (double)transform.translation.field_72448_b, (double)transform.translation.field_72449_c);
        }
        InteractionRenderers.renderItemCount(fontRenderer, yaw, itemStack.func_190916_E(), offset);
        GlStateManager.func_179121_F();
    }

    public static void renderItemModelCustom(RenderItem renderItem, ItemStack itemStack, Transform transform) {
        GlStateManager.func_179094_E();
        InteractionRenderers.setupItemTransforms(transform);
        IBakedModel model = renderItem.func_184393_a(itemStack, null, null);
        RenderHelper.renderItemModelCustom(itemStack, model, ItemCameraTransforms.TransformType.NONE, false, false);
        GlStateManager.func_179121_F();
    }

    public static void setupAdditiveGLState() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179091_B();
    }

    public static void cleanupAdditiveGLState() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
    }

    public static void setupItemTransforms(Transform transform) {
        if (transform != Transform.IDENTITY) {
            if (transform.lwjglRotation == null) {
                transform.lwjglRotation = new Quaternion();
            }
            transform.lwjglRotation.x = transform.rotation.x;
            transform.lwjglRotation.y = transform.rotation.y;
            transform.lwjglRotation.z = transform.rotation.z;
            transform.lwjglRotation.w = transform.rotation.w;
            GlStateManager.func_179137_b((double)transform.translation.field_72450_a, (double)transform.translation.field_72448_b, (double)transform.translation.field_72449_c);
            GlStateManager.func_187444_a((Quaternion)transform.lwjglRotation);
            GlStateManager.func_179139_a((double)transform.scale.field_72450_a, (double)transform.scale.field_72448_b, (double)transform.scale.field_72449_c);
        }
    }

    public static void renderItemCount(FontRenderer fontRenderer, int yaw, int count, Vec3d offset) {
        if (count <= 1) {
            return;
        }
        int verticalShift = 0;
        String countString = String.valueOf(count);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        float viewerYaw = renderManager.field_78735_i;
        float viewerPitch = renderManager.field_78732_j;
        int i = fontRenderer.func_78256_a(countString) / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)offset.field_72450_a, (double)offset.field_72448_b, (double)offset.field_72449_c);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-viewerYaw - (float)yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)viewerPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.0125f, (float)-0.0125f, (float)0.0125f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)(-i - 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(-i - 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        fontRenderer.func_78276_b(countString, -fontRenderer.func_78256_a(countString) / 2, verticalShift, Color.WHITE.getRGB());
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    private InteractionRenderers() {
    }

    public static class InteractionRenderer_ItemStack
    implements IInteractionRenderer<IInteractionItemStack> {
        @Override
        public void renderSolidPass(IInteractionItemStack interaction, World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            if (!interaction.isEmpty()) {
                ItemStack itemStack = interaction.getStackInSlot();
                Transform transform = interaction.getTransform(world, pos, blockState, itemStack, partialTicks);
                InteractionRenderers.renderItemModel(renderItem, itemStack, transform);
            }
        }

        @Override
        public void renderSolidPassText(IInteractionItemStack interaction, World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
            if (!interaction.isEmpty()) {
                ItemStack itemStack = interaction.getStackInSlot();
                Transform transform = interaction.getTransform(world, pos, blockState, itemStack, partialTicks);
                InteractionRenderers.renderItemCount(fontRenderer, yaw, itemStack, transform, offset);
            }
        }

        @Override
        public boolean renderAdditivePass(IInteractionItemStack interaction, World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            if (interaction.isEmpty() && interaction.shouldRenderAdditivePassForHeldItem(heldItemMainHand)) {
                if (interaction.isItemStackValid(heldItemMainHand)) {
                    Transform transform = interaction.getTransform(world, hitPos, blockState, heldItemMainHand, partialTicks);
                    InteractionRenderers.setupAdditiveGLState();
                    InteractionRenderers.renderItemModelCustom(renderItem, heldItemMainHand, transform);
                    InteractionRenderers.cleanupAdditiveGLState();
                    return true;
                }
            } else if (!interaction.isEmpty() && interaction.shouldRenderAdditivePassForStackInSlot(Minecraft.func_71410_x().field_71439_g.func_70093_af(), heldItemMainHand)) {
                ItemStack itemStack = interaction.getStackInSlot();
                Transform transform = interaction.getTransform(world, hitPos, blockState, itemStack, partialTicks);
                if (!itemStack.func_190926_b()) {
                    InteractionRenderers.setupAdditiveGLState();
                    InteractionRenderers.renderItemModelCustom(renderItem, itemStack, transform);
                    InteractionRenderers.cleanupAdditiveGLState();
                    return true;
                }
            }
            return false;
        }
    }
}

