/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.teamacronymcoders.base.Base;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class PositionUtils {
    private static String[] position_pairs = new String[]{"x_y", "x_z", "y_z", "y_x"};

    public static boolean arePositionsAlignedOnTwoAxes(BlockPos first, BlockPos second) {
        for (String pair : position_pairs) {
            String[] split = pair.split("_");
            if (PositionUtils.convertStringToPosVal(split[0], first) != PositionUtils.convertStringToPosVal(split[0], second) || PositionUtils.convertStringToPosVal(split[1], first) != PositionUtils.convertStringToPosVal(split[1], second)) continue;
            return true;
        }
        return false;
    }

    private static int convertStringToPosVal(String pos_name, BlockPos pos) {
        if (pos_name.equalsIgnoreCase("x")) {
            return pos.func_177958_n();
        }
        if (pos_name.equalsIgnoreCase("y")) {
            return pos.func_177956_o();
        }
        if (pos_name.equalsIgnoreCase("z")) {
            return pos.func_177952_p();
        }
        return 0;
    }

    public static boolean isLOSClear(World world, BlockPos first, BlockPos second) {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)first, (BlockPos)second)) {
            if (pos.equals((Object)first) || pos.equals((Object)second)) {
                Base.instance.getLogger().devInfo("Skipping " + pos.toString());
                continue;
            }
            Base.instance.getLogger().devInfo("Checking " + pos.toString());
            if (world.func_175623_d(pos)) continue;
            return false;
        }
        return true;
    }

    public static void removeBlocksInArea(World world, BlockPos from, BlockPos to) {
        PositionUtils.replaceBlocksIn(world, from, to, null);
    }

    public static void replaceBlocksIn(World world, BlockPos from, BlockPos to, IBlockState target) {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)from, (BlockPos)to)) {
            if (pos.equals((Object)from) || pos.equals((Object)to)) continue;
            if (target == null) {
                world.func_175698_g(pos);
                continue;
            }
            world.func_175656_a(pos, target);
        }
    }

    public static ArrayList<IBlockState> getBlocksOfTypeNearby(World world, BlockPos pos, IBlockState state) {
        ArrayList<IBlockState> blocks = new ArrayList<IBlockState>();
        for (EnumFacing element : EnumFacing.field_82609_l) {
            BlockPos off = pos.func_177972_a(element);
            if (world.func_180495_p(off) != state) continue;
            blocks.add(world.func_180495_p(off));
        }
        return blocks;
    }

    public static int getDistanceBetweenPositions(BlockPos clicked_pos, BlockPos saved_pos) {
        return (int)Math.round(clicked_pos.func_185332_f(saved_pos.func_177958_n(), saved_pos.func_177956_o(), saved_pos.func_177952_p()));
    }

    public static EnumFacing getFacingFromPositions(BlockPos from, BlockPos to) {
        int x = from.func_177973_b((Vec3i)to).func_177958_n();
        int y = from.func_177973_b((Vec3i)to).func_177956_o();
        int z = from.func_177973_b((Vec3i)to).func_177952_p();
        if (x > 0) {
            return EnumFacing.EAST;
        }
        if (x < 0) {
            return EnumFacing.WEST;
        }
        if (y < 0) {
            return EnumFacing.DOWN;
        }
        if (y > 0) {
            return EnumFacing.UP;
        }
        if (z < 0) {
            return EnumFacing.NORTH;
        }
        if (z > 0) {
            return EnumFacing.SOUTH;
        }
        return null;
    }

    public static Pair<BlockPos, BlockPos> shrinkPositionCubeBy(BlockPos minimumCoord, BlockPos maximumCoord, int by) {
        int minX = minimumCoord.func_177958_n();
        int minY = minimumCoord.func_177956_o();
        int minZ = minimumCoord.func_177952_p();
        int maxX = maximumCoord.func_177958_n();
        int maxY = maximumCoord.func_177956_o();
        int maxZ = maximumCoord.func_177952_p();
        int interiorMinX = (int)Math.copySign((float)Math.abs(minX) + Math.signum(minX) * (float)by, minX);
        int interiorMinY = minY + by;
        int interiorMinZ = (int)Math.copySign((float)Math.abs(minZ) + Math.signum(minZ) * (float)by, minZ);
        int interiorMaxX = (int)Math.copySign((float)Math.abs(maxX) - Math.signum(maxX) * (float)by, maxX);
        int interiorMaxY = maxY - by;
        int interiorMaxZ = (int)Math.copySign((float)Math.abs(maxZ) - Math.signum(maxZ) * (float)by, maxZ);
        BlockPos minimumInteriorPos = new BlockPos(interiorMinX, interiorMinY, interiorMinZ);
        BlockPos maximumInteriorPos = new BlockPos(interiorMaxX, interiorMaxY, interiorMaxZ);
        return Pair.of((Object)minimumInteriorPos, (Object)maximumInteriorPos);
    }
}

