/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.items.boats;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.client.models.IHasModel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class ItemBoatBase<BOAT extends EntityBoat>
extends ItemBoat
implements IHasModel {
    private boolean creativeTabSet = false;
    private IBaseMod mod;

    public ItemBoatBase(String unlocalizedName) {
        super(EntityBoat.Type.OAK);
        this.func_77655_b(unlocalizedName);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand) {
        float f8;
        float f6;
        double d3;
        float f5;
        ItemStack itemStack = entityPlayer.func_184586_b(hand);
        float f = 1.0f;
        float f1 = entityPlayer.field_70127_C + (entityPlayer.field_70125_A - entityPlayer.field_70127_C) * f;
        float f2 = entityPlayer.field_70126_B + (entityPlayer.field_70177_z - entityPlayer.field_70126_B) * f;
        double d0 = entityPlayer.field_70169_q + (entityPlayer.field_70165_t - entityPlayer.field_70169_q) * (double)f;
        double d1 = entityPlayer.field_70167_r + (entityPlayer.field_70163_u - entityPlayer.field_70167_r) * (double)f + (double)entityPlayer.func_70047_e();
        double d2 = entityPlayer.field_70166_s + (entityPlayer.field_70161_v - entityPlayer.field_70166_s) * (double)f;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180))));
        Vec3d vec3d1 = vec3d.func_72441_c((double)f7 * (d3 = 5.0), (double)(f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)))) * d3, (double)(f8 = f3 * f5) * d3);
        RayTraceResult raytraceresult = world.func_72901_a(vec3d, vec3d1, true);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        Vec3d vec3d2 = entityPlayer.func_70676_i(f);
        boolean flag = false;
        List list = world.func_72839_b((Entity)entityPlayer, entityPlayer.func_174813_aQ().func_72321_a(vec3d2.field_72450_a * 5.0, vec3d2.field_72448_b * 5.0, vec3d2.field_72449_c * 5.0).func_186662_g(1.0));
        for (Entity entity : list) {
            AxisAlignedBB axisalignedbb;
            if (!entity.func_70067_L() || !(axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y())).func_72318_a(vec3d)) continue;
            flag = true;
        }
        if (flag) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        Block block = world.func_180495_p(raytraceresult.func_178782_a()).func_177230_c();
        boolean isWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i;
        BOAT entityBoat = this.getBoatToPlace(world, itemStack);
        double boatPosX = raytraceresult.field_72307_f.field_72450_a;
        double boatPosY = isWater ? raytraceresult.field_72307_f.field_72448_b - 0.12 : raytraceresult.field_72307_f.field_72448_b;
        double boatPosZ = raytraceresult.field_72307_f.field_72449_c;
        entityBoat.func_70107_b(boatPosX, boatPosY, boatPosZ);
        entityBoat.func_184458_a(this.getType(itemStack));
        ((EntityBoat)entityBoat).field_70177_z = entityPlayer.field_70177_z;
        if (!world.func_184144_a(entityBoat, entityBoat.func_174813_aQ().func_186662_g(-0.1)).isEmpty()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        if (!world.field_72995_K) {
            world.func_72838_d(entityBoat);
            this.onPlace(entityBoat, entityPlayer, hand, itemStack);
        }
        this.increaseStat(entityPlayer);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    protected EntityBoat.Type getType(ItemStack itemStack) {
        return EntityBoat.Type.values()[itemStack.func_77952_i()];
    }

    public abstract BOAT getBoatToPlace(World var1, ItemStack var2);

    protected void onPlace(BOAT placedBoat, EntityPlayer entityPlayer, EnumHand hand, ItemStack itemStack) {
    }

    public void increaseStat(EntityPlayer entityPlayer) {
        StatBase stat = StatList.func_188057_b((Item)this);
        if (stat != null) {
            entityPlayer.func_71029_a(stat);
        }
    }

    @Nonnull
    public Item func_77637_a(@Nonnull CreativeTabs tab) {
        if (!this.creativeTabSet) {
            super.func_77637_a(tab);
            this.creativeTabSet = true;
        }
        return this;
    }

    @Override
    public List<String> getModelNames(List<String> modelNames) {
        this.getAllSubItems(Lists.newArrayList()).forEach(itemStack -> modelNames.add(this.func_77667_c((ItemStack)itemStack)));
        return modelNames;
    }

    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> itemStacks) {
        if (tab != null && tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            itemStacks.addAll(this.getAllSubItems(Lists.newArrayList()));
        }
    }

    @Override
    public List<ItemStack> getAllSubItems(List<ItemStack> itemStacks) {
        itemStacks.add(new ItemStack((Item)this, 1, 0));
        return itemStacks;
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public IBaseMod getMod() {
        return this.mod;
    }

    @Override
    public void setMod(IBaseMod mod) {
        this.mod = mod;
    }
}

