/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.util;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.ilexiconn.llibrary.LLibrary;
import net.minecraft.crash.CrashReport;
import org.apache.commons.io.IOUtils;

public class WebUtils {
    public static final String PASTEBIN_URL_PREFIX = "http://pastebin.com/raw.php?i=";
    private static final ListeningExecutorService EXECUTOR = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));

    public static String readPastebin(String pasteID) {
        return WebUtils.readURL(PASTEBIN_URL_PREFIX + pasteID);
    }

    public static List<String> readPastebinAsList(String pasteID) {
        return WebUtils.readURLAsList(PASTEBIN_URL_PREFIX + pasteID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readURL(String url) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to receive data from URL: " + url)).func_71502_e());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readURLAsList(String url) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));){
            List list = IOUtils.readLines((Reader)reader);
            return list;
        }
        catch (IOException e) {
            LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to receive data from URL: " + url)).func_71502_e());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage downloadImage(String url) {
        try (BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());){
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (IOException e) {
            LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to receive data from URL: " + url)).func_71502_e());
            return null;
        }
    }

    public static ListenableFuture<String> readURLAsync(String url) {
        return EXECUTOR.submit(() -> WebUtils.readURL(url));
    }

    public static ListenableFuture<List<String>> readURLAsListAsync(String url) {
        return EXECUTOR.submit(() -> WebUtils.readURLAsList(url));
    }

    public static ListenableFuture<String> readPastebinAsync(String pasteID) {
        return EXECUTOR.submit(() -> WebUtils.readPastebin(pasteID));
    }

    public static ListenableFuture<List<String>> readPastebinAsListAsync(String pasteID) {
        return EXECUTOR.submit(() -> WebUtils.readURLAsList(pasteID));
    }
}

