/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.tabula.animation;

import java.util.List;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaAnimationComponentContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaAnimationContainer;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.animation.NamedAnimation;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class AnimationPlayerAnimator<T extends Entity>
implements ITabulaModelAnimator<T> {
    @Override
    public void setRotationAngles(TabulaModel model, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        float partialTicks = LLibrary.PROXY.getPartialTicks();
        Animation anim = ((IAnimatedEntity)entity).getAnimation();
        if (!(anim instanceof NamedAnimation)) {
            return;
        }
        TabulaAnimationContainer animation = model.getAnimation(((NamedAnimation)anim).getName());
        if (animation == null) {
            return;
        }
        this.prepareAnimation(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, partialTicks);
        animation.getComponents().entrySet().forEach(entry -> {
            for (TabulaAnimationComponentContainer component : (List)entry.getValue()) {
                this.applyComponent(component, model.getCubeByIdentifier((String)entry.getKey()), entity, partialTicks);
            }
        });
        this.finishAnimation(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, partialTicks);
    }

    protected void prepareAnimation(TabulaModel model, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float partialTicks) {
    }

    protected void finishAnimation(TabulaModel model, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float partialTicks) {
    }

    private void applyComponent(TabulaAnimationComponentContainer component, AdvancedModelRenderer cube, T entity, float partialTicks) {
        float tick = (float)((IAnimatedEntity)entity).getAnimationTick() + partialTicks;
        double progress = (double)(tick - (float)component.getStartKey()) / (double)component.getLength();
        progress = MathHelper.func_151237_a((double)progress, (double)0.0, (double)1.0);
        if (tick >= (float)component.getStartKey()) {
            cube.field_78795_f = (float)((double)cube.field_78795_f + Math.toRadians(component.getRotationOffset()[0]));
            cube.field_78796_g = (float)((double)cube.field_78796_g + Math.toRadians(component.getRotationOffset()[1]));
            cube.field_78808_h = (float)((double)cube.field_78808_h + Math.toRadians(component.getRotationOffset()[2]));
            cube.field_78800_c = (float)((double)cube.field_78800_c + component.getPositionOffset()[0]);
            cube.field_78797_d = (float)((double)cube.field_78797_d + component.getPositionOffset()[1]);
            cube.field_78798_e = (float)((double)cube.field_78798_e + component.getPositionOffset()[2]);
            cube.scaleX = (float)((double)cube.scaleX + component.getScaleOffset()[0]);
            cube.scaleY = (float)((double)cube.scaleY + component.getScaleOffset()[1]);
            cube.scaleZ = (float)((double)cube.scaleZ + component.getScaleOffset()[2]);
            cube.opacity = (float)((double)cube.opacity + component.getOpacityOffset());
        }
        cube.field_78795_f = (float)((double)cube.field_78795_f + Math.toRadians(component.getRotationChange()[0] * progress));
        cube.field_78796_g = (float)((double)cube.field_78796_g + Math.toRadians(component.getRotationChange()[1] * progress));
        cube.field_78808_h = (float)((double)cube.field_78808_h + Math.toRadians(component.getRotationChange()[2] * progress));
        cube.field_78800_c = (float)((double)cube.field_78800_c + component.getPositionChange()[0] * progress);
        cube.field_78797_d = (float)((double)cube.field_78797_d + component.getPositionChange()[1] * progress);
        cube.field_78798_e = (float)((double)cube.field_78798_e + component.getPositionChange()[2] * progress);
        cube.scaleX = (float)((double)cube.scaleX + component.getScaleChange()[0] * progress);
        cube.scaleY = (float)((double)cube.scaleY + component.getScaleChange()[1] * progress);
        cube.scaleZ = (float)((double)cube.scaleZ + component.getScaleChange()[2] * progress);
        cube.opacity = (float)((double)cube.opacity + component.getOpacityChange() * progress);
    }
}

