/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank;

import com.kotori316.fluidtank.Config;
import com.kotori316.fluidtank.blocks.AbstractTank;
import com.kotori316.fluidtank.blocks.BlockTank;
import com.kotori316.fluidtank.packet.PacketHandler;
import com.kotori316.fluidtank.packet.SideProxy;
import com.kotori316.fluidtank.recipes.ConvertInvisibleRecipe$;
import com.kotori316.fluidtank.recipes.EmptyTankRecipe$;
import com.kotori316.fluidtank.recipes.TankRecipe;
import com.kotori316.fluidtank.tiles.Tiers;
import com.kotori316.fluidtank.tiles.TileTank;
import com.kotori316.fluidtank.tiles.TileTankCreative;
import com.kotori316.fluidtank.tiles.TileTankNoDisplay;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="FluidTank", modid="fluidtank", version="12.5.2", certificateFingerprint="617a4e95f0af9de5402bb9883abe0f53a6bfa230", updateJSON="https://raw.githubusercontent.com/Kotori316/FluidTank/master/update.json", guiFactory="com.kotori316.fluidtank.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class FluidTank {
    public static final FluidTank instance;
    public static final String MOD_NAME = "FluidTank";
    public static final String modID = "fluidtank";
    public static final Logger LOGGER;
    @SidedProxy(clientSide="com.kotori316.fluidtank.packet.ClientProxy", serverSide="com.kotori316.fluidtank.packet.ServerProxy")
    public static SideProxy proxy;
    public static final List<AbstractTank> BLOCK_TANKS;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        Config.load(event.getSuggestedConfigurationFile());
        proxy.registerTESR();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PacketHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BLOCK_TANKS.toArray(new AbstractTank[0]));
        TileEntity.func_190560_a((String)"fluidtank:tiletank", TileTank.class);
        TileEntity.func_190560_a((String)"fluidtank:tiletanknodisplay", TileTankNoDisplay.class);
        TileEntity.func_190560_a((String)"fluidtank:tiletankcreative", TileTankCreative.class);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BLOCK_TANKS.stream().map(AbstractTank::itemBlock).toArray(Item[]::new));
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (!Config.content().removeRecipe()) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])Tiers.jList().stream().map(TankRecipe::new).filter(TankRecipe::isValid).toArray(IRecipe[]::new));
        }
        event.getRegistry().register((IForgeRegistryEntry)ConvertInvisibleRecipe$.MODULE$);
        event.getRegistry().register((IForgeRegistryEntry)EmptyTankRecipe$.MODULE$);
    }

    @Mod.InstanceFactory
    public static FluidTank getInstance() {
        return instance;
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_NAME);
        BLOCK_TANKS = Arrays.asList(new AbstractTank[]{BlockTank.blockTank1(), BlockTank.blockTank2(), BlockTank.blockTank3(), BlockTank.blockTank4(), BlockTank.blockTank5(), BlockTank.blockTank6(), BlockTank.blockTank7(), BlockTank.blockTankCreative()});
        instance = new FluidTank();
        if (Launch.blackboard.getOrDefault("fml.deobfuscatedEnvironment", Boolean.FALSE).booleanValue()) {
            FluidRegistry.enableUniversalBucket();
        }
    }
}

