/*
 * Decompiled with CFR 0.152.
 */
package openmods.words;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Random;
import openmods.words.IGenerator;

public class Alternative
implements IGenerator {
    private final List<IGenerator> alts;

    public Alternative(IGenerator ... alts) {
        this.alts = ImmutableList.copyOf((Object[])alts);
    }

    @Override
    public String generate(Random random, Map<String, String> params) {
        if (this.alts.isEmpty()) {
            return "";
        }
        int choice = random.nextInt(this.alts.size());
        return this.alts.get(choice).generate(random, params);
    }

    @Override
    public BigInteger count() {
        BigInteger result = BigInteger.ZERO;
        for (IGenerator alt : this.alts) {
            result = result.add(alt.count());
        }
        return result;
    }
}

