/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import com.google.common.collect.Lists;
import java.util.List;
import jline.internal.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ContainerBucketFillHandler {
    @GameRegistry.ObjectHolder(value="minecraft:bucket")
    private static final Item EMPTY_BUCKET = null;
    private final List<Pair<FluidStack, ItemStack>> buckets = Lists.newArrayList();

    protected abstract boolean canFill(World var1, BlockPos var2, TileEntity var3);

    public ContainerBucketFillHandler addFilledBucket(ItemStack filledBucket) {
        FluidStack containedFluid = FluidUtil.getFluidContained((ItemStack)filledBucket);
        if (containedFluid != null) {
            this.buckets.add((Pair<FluidStack, ItemStack>)Pair.of((Object)containedFluid.copy(), (Object)filledBucket.func_77946_l()));
        } else {
            Log.warn((Object[])new Object[]{"Item %s is not a filled bucket", filledBucket});
        }
        return this;
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent evt) {
        FluidStack fluidInBucket;
        IFluidHandlerItem container;
        ItemStack filledBucket;
        IFluidHandler source;
        FluidStack fluidInContainer;
        if (evt.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (evt.getEmptyBucket().func_77973_b() != EMPTY_BUCKET) {
            return;
        }
        RayTraceResult target = evt.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        TileEntity te = evt.getWorld().func_175625_s(target.func_178782_a());
        if (te == null) {
            return;
        }
        if (!this.canFill(evt.getWorld(), target.func_178782_a(), te)) {
            return;
        }
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.field_178784_b) && (fluidInContainer = (source = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.field_178784_b)).drain(1000, false)) != null && !(filledBucket = this.getFilledBucket(fluidInContainer)).func_190926_b() && (container = FluidUtil.getFluidHandler((ItemStack)filledBucket)) != null && (fluidInBucket = container.drain(Integer.MAX_VALUE, false)) != null && fluidInBucket.isFluidStackIdentical(source.drain(fluidInBucket, false))) {
            source.drain(fluidInBucket, true);
            evt.setFilledBucket(filledBucket.func_77946_l());
            evt.setResult(Event.Result.ALLOW);
        }
    }

    private ItemStack getFilledBucket(FluidStack fluid) {
        for (Pair<FluidStack, ItemStack> e : this.buckets) {
            if (!((FluidStack)e.getLeft()).isFluidEqual(fluid)) continue;
            return (ItemStack)e.getRight();
        }
        return FluidUtil.getFilledBucket((FluidStack)fluid);
    }
}

