/*
 * Decompiled with CFR 0.152.
 */
package openmods.item;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openmods.block.OpenBlock;

public class ItemOpenBlock
extends ItemBlock {
    public ItemOpenBlock(Block block) {
        super(block);
    }

    protected void afterBlockPlaced(@Nonnull ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        stack.func_190918_g(1);
    }

    protected boolean isStackValid(@Nonnull ItemStack stack, EntityPlayer player) {
        return !stack.func_190926_b();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        OpenBlock openBlock;
        ItemStack stack;
        IBlockState clickedBlockState = world.func_180495_p(pos);
        Block clickedBlock = clickedBlockState.func_177230_c();
        if (!clickedBlock.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!this.isStackValid(stack = player.func_184586_b(hand), player)) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (!world.func_190527_a(this.field_150939_a, pos, false, facing, (Entity)null)) {
            return EnumActionResult.FAIL;
        }
        int itemMetadata = this.func_77647_b(stack.func_77960_j());
        if (this.field_150939_a instanceof OpenBlock && !(openBlock = (OpenBlock)this.field_150939_a).canBlockBePlaced(world, pos, hand, facing, hitX, hitY, hitZ, itemMetadata, player)) {
            return EnumActionResult.FAIL;
        }
        IBlockState newBlockState = this.field_150939_a.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, itemMetadata, (EntityLivingBase)player, hand);
        if (this.placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, newBlockState)) {
            SoundType soundType = this.field_150939_a.getSoundType(newBlockState, world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
            this.afterBlockPlaced(stack, player, world, pos);
        }
        return EnumActionResult.SUCCESS;
    }
}

