/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.misc;

import net.minecraft.client.gui.Gui;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class BoxRenderer {
    private final int u;
    private final int v;

    public BoxRenderer(int u, int v) {
        this.u = u;
        this.v = v;
    }

    protected void renderTopLeftCorner(Gui gui) {
        gui.func_73729_b(0, 0, this.u, this.v, 4, 4);
    }

    protected void renderTopRightCorner(Gui gui, int width) {
        gui.func_73729_b(width - 3, 0, this.u + 5, this.v, 3, 3);
    }

    protected void renderBottomLeftCorner(Gui gui, int height) {
        gui.func_73729_b(0, height - 3, this.u + 11, this.v, 3, 3);
    }

    protected void renderBottomRightCorner(Gui gui, int width, int height) {
        gui.func_73729_b(width - 4, height - 4, this.u + 15, this.v, 4, 4);
    }

    protected void renderBottomEdge(Gui gui, int width, int height) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)3.0f, (float)(height - 3), (float)0.0f);
        GL11.glScaled((double)(width - 7), (double)1.0, (double)0.0);
        gui.func_73729_b(0, 0, this.u + 14, this.v, 1, 3);
        GL11.glPopMatrix();
    }

    protected void renderTopEdge(Gui gui, int width) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)4.0f, (float)0.0f, (float)0.0f);
        GL11.glScaled((double)(width - 7), (double)1.0, (double)0.0);
        gui.func_73729_b(0, 0, this.u + 4, this.v, 1, 3);
        GL11.glPopMatrix();
    }

    protected void renderLeftEdge(Gui gui, int height) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)4.0f, (float)0.0f);
        GL11.glScaled((double)1.0, (double)(height - 7), (double)0.0);
        gui.func_73729_b(0, 0, this.u, this.v + 4, 3, 1);
        GL11.glPopMatrix();
    }

    protected void renderRightEdge(Gui gui, int width, int height) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(width - 3), (float)3.0f, (float)0.0f);
        GL11.glScaled((double)1.0, (double)(height - 7), (double)0.0);
        gui.func_73729_b(0, 0, this.u + 8, this.v, 3, 1);
        GL11.glPopMatrix();
    }

    protected void renderBackground(Gui gui, int width, int height) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)2.0f, (float)2.0f, (float)0.0f);
        GL11.glScalef((float)(width - 4), (float)(height - 4), (float)0.0f);
        gui.func_73729_b(0, 0, this.u + 19, this.v, 1, 1);
        GL11.glPopMatrix();
    }

    public void render(Gui gui, int x, int y, int width, int height, int color) {
        RenderUtils.setColor(color);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        this.renderBackground(gui, width, height);
        this.renderTopEdge(gui, width);
        this.renderBottomEdge(gui, width, height);
        this.renderLeftEdge(gui, height);
        this.renderRightEdge(gui, width, height);
        this.renderTopLeftCorner(gui);
        this.renderTopRightCorner(gui, width);
        this.renderBottomLeftCorner(gui, height);
        this.renderBottomRightCorner(gui, width, height);
        GL11.glPopMatrix();
    }
}

